/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.swing.panels.splitpane;

import de.alpharogroup.layout.ScreenSizeExtensions;
import de.alpharogroup.model.api.Model;
import de.alpharogroup.swing.base.BasePanel;
import de.alpharogroup.swing.components.factories.DimensionFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import org.jdesktop.swingx.JXMultiSplitPane;
import org.jdesktop.swingx.MultiSplitLayout;

public class JXMultiSplitPanePanel<T>
extends BasePanel<T> {
    private static final long serialVersionUID = 1L;
    private JXMultiSplitPane multiSplitPane;

    public JXMultiSplitPanePanel() {
    }

    public JXMultiSplitPanePanel(Model<T> model) {
        super(model);
    }

    protected JXMultiSplitPane newJXMultiSplitPane(String layoutDefinition) {
        JXMultiSplitPane msp = new JXMultiSplitPane();
        MultiSplitLayout.Node modelRoot = this.newRootNode(layoutDefinition);
        msp.getMultiSplitLayout().setModel(modelRoot);
        msp.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        return msp;
    }

    protected String newLayoutDefinition() {
        String layoutDefinition = "(COLUMN (ROW weight=0.8 (COLUMN weight=0.25 (LEAF name=left.top weight=0.5) (LEAF name=left.middle weight=0.5))(LEAF name=editor weight=0.75)) (LEAF name=bottom weight=0.2))";
        return layoutDefinition;
    }

    protected Dimension newPreferredSize(int width, int height) {
        return DimensionFactory.newDimension(width, height);
    }

    protected MultiSplitLayout.Node newRootNode(String layoutDefinition) {
        return MultiSplitLayout.parseModel((String)layoutDefinition);
    }

    @Override
    protected void onInitializeComponents() {
        super.onInitializeComponents();
        this.multiSplitPane = this.newJXMultiSplitPane(this.newLayoutDefinition());
        int screenHeight = (int)((double)ScreenSizeExtensions.getScreenHeight() / 1.1);
        int screenWidth = (int)((double)ScreenSizeExtensions.getScreenWidth() / 1.1);
        this.setPreferredSize(this.newPreferredSize(screenWidth, screenHeight));
    }

    @Override
    protected void onInitializeLayout() {
        super.onInitializeLayout();
        this.setLayout(new BorderLayout());
        this.add((Component)this.multiSplitPane, "Center");
    }

    public JXMultiSplitPane getMultiSplitPane() {
        return this.multiSplitPane;
    }
}

