/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.swing.panels.preferences;

import de.alpharogroup.model.api.Model;
import de.alpharogroup.swing.base.BasePanel;
import de.alpharogroup.swing.components.factories.JComponentFactory;
import de.alpharogroup.swing.panels.preferences.ComponentTreeNode;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;

public abstract class PreferencesPanel<T>
extends BasePanel<T> {
    private static final long serialVersionUID = 1L;
    protected JScrollPane scrTree;
    protected JSplitPane splitPane;
    protected JTree tree;
    protected TreeModel treeModel;

    public PreferencesPanel(Model<T> model) {
        super(model);
    }

    protected void addTreeComponent(String title, Component c) {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.treeModel.getRoot();
        root.add(new ComponentTreeNode(title, c));
    }

    protected Component getSelectedComponent() {
        Object o = this.tree.getLastSelectedPathComponent();
        if (o instanceof ComponentTreeNode) {
            return ((ComponentTreeNode)o).getComponent();
        }
        return null;
    }

    protected JSplitPane newJSplitPane() {
        return JComponentFactory.newJSplitPane(this.scrTree, null);
    }

    protected Dimension newPreferredSize(int width, int height) {
        return new Dimension(width, height);
    }

    protected JTree newTree() {
        this.treeModel = this.newTreeModel(this.getModel());
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.treeModel.getRoot();
        final JTree tree = new JTree(root);
        tree.setEditable(false);
        tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                PreferencesPanel.this.splitPane.setRightComponent(PreferencesPanel.this.getSelectedComponent());
            }
        });
        tree.getSelectionModel().setSelectionMode(1);
        tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                int selRow = tree.getRowForLocation(e.getX(), e.getY());
                if (selRow != -1) {
                    if (e.getClickCount() == 1) {
                        PreferencesPanel.this.onSingleClick(e);
                    } else if (e.getClickCount() == 2) {
                        PreferencesPanel.this.onDoubleClick(e);
                    }
                }
            }
        });
        return tree;
    }

    protected abstract TreeModel newTreeModel(Model<T> var1);

    protected JScrollPane newTreeScrollPane() {
        JScrollPane scrDbTree = new JScrollPane();
        return scrDbTree;
    }

    protected void onDoubleClick(MouseEvent event) {
    }

    @Override
    protected void onInitializeComponents() {
        super.onInitializeComponents();
        this.scrTree = this.newTreeScrollPane();
        this.tree = this.newTree();
        this.setPreferredSize(this.newPreferredSize(420, 560));
        this.scrTree.setViewportView(this.tree);
        this.splitPane = this.newJSplitPane();
    }

    @Override
    protected void onInitializeLayout() {
        super.onInitializeLayout();
    }

    protected void onSingleClick(MouseEvent event) {
    }
}

