/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.swing.img;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfWriter;
import de.alpharogroup.random.object.RandomObjectFactory;
import de.alpharogroup.swing.img.Direction;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import org.imgscalr.Scalr;

public class ImageExtensions {
    private static final Logger log = Logger.getLogger(ImageExtensions.class.getName());

    public static BufferedImage concatenateImages(List<BufferedImage> imgCollection, int width, int height, int imageType, Direction concatenationDirection) {
        BufferedImage img = new BufferedImage(width, height, imageType);
        int x = 0;
        int y = 0;
        for (BufferedImage bi : imgCollection) {
            boolean imageDrawn = img.createGraphics().drawImage((Image)bi, x, y, null);
            if (!imageDrawn) {
                throw new RuntimeException("BufferedImage could not be drawn:" + bi.toString());
            }
            if (concatenationDirection.equals((Object)Direction.vertical)) {
                y += bi.getHeight();
                continue;
            }
            x += bi.getWidth();
        }
        return img;
    }

    public static void createPdf(OutputStream result, List<BufferedImage> images) throws DocumentException, IOException {
        Document document = new Document();
        PdfWriter.getInstance((Document)document, (OutputStream)result);
        for (BufferedImage image : images) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)image, "png", baos);
            com.itextpdf.text.Image img = com.itextpdf.text.Image.getInstance((byte[])baos.toByteArray());
            document.setPageSize((Rectangle)img);
            document.newPage();
            img.setAbsolutePosition(0.0f, 0.0f);
            document.add((Element)img);
        }
        document.close();
    }

    public static BufferedImage getResized(BufferedImage originalImage, Scalr.Method scalingMethod, Scalr.Mode resizeMode, String formatName, int targetWidth, int targetHeight) throws IOException {
        return ImageExtensions.read(ImageExtensions.resize(originalImage, scalingMethod, resizeMode, formatName, targetWidth, targetHeight));
    }

    public static BufferedImage getResized(BufferedImage originalImage, String formatName, int targetWidth, int targetHeight) throws IOException {
        return ImageExtensions.read(ImageExtensions.resize(originalImage, formatName, targetWidth, targetHeight));
    }

    public static ImageIcon newImageIcon(File image) {
        ImageIcon img = ImageExtensions.newImageIcon(image.getAbsolutePath());
        return img;
    }

    public static ImageIcon newImageIcon(String imagePath) {
        ImageIcon img = new ImageIcon(imagePath);
        return img;
    }

    public static PdfPTable newPdfPTable(int numColumns, List<String> headerNames) {
        PdfPTable table = new PdfPTable(numColumns);
        headerNames.stream().forEach(columnHeaderName -> {
            PdfPCell header = new PdfPCell();
            header.setBackgroundColor(BaseColor.LIGHT_GRAY);
            header.setBorderWidth(2.0f);
            header.setPhrase(new Phrase(columnHeaderName));
            table.addCell(header);
        });
        return table;
    }

    public static BufferedImage randomBufferedImage(int width, int height, int imageType) {
        BufferedImage img = new BufferedImage(width, height, imageType);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                img.setRGB(x, y, RandomObjectFactory.randomPixel());
            }
        }
        return img;
    }

    public static BufferedImage read(byte[] byteArray) throws IOException {
        return ImageIO.read(new ByteArrayInputStream(byteArray));
    }

    public static BufferedImage readQuietly(byte[] byteArray) {
        BufferedImage img = null;
        try {
            img = ImageExtensions.read(byteArray);
        }
        catch (IOException e) {
            log.log(Level.SEVERE, "Reading image failed.", e);
        }
        return img;
    }

    public static BufferedImage readQuietly(InputStream input) {
        BufferedImage img = null;
        try {
            img = ImageIO.read(input);
        }
        catch (IOException e) {
            log.log(Level.SEVERE, "Reading image failed.", e);
        }
        return img;
    }

    public static byte[] resize(BufferedImage originalImage, Scalr.Method scalingMethod, Scalr.Mode resizeMode, String formatName, int targetWidth, int targetHeight) {
        try {
            BufferedImage resizedImage = Scalr.resize((BufferedImage)originalImage, (Scalr.Method)scalingMethod, (Scalr.Mode)resizeMode, (int)targetWidth, (int)targetHeight, (BufferedImageOp[])new BufferedImageOp[0]);
            return ImageExtensions.toByteArray(resizedImage, formatName);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static byte[] resize(BufferedImage originalImage, String formatName, int targetWidth, int targetHeight) {
        return ImageExtensions.resize(originalImage, Scalr.Method.QUALITY, Scalr.Mode.FIT_EXACT, formatName, targetWidth, targetHeight);
    }

    public static byte[] toByteArray(BufferedImage bi, String formatName) throws IOException {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            byte[] byteArray;
            ImageIO.write((RenderedImage)bi, formatName, baos);
            baos.flush();
            byte[] byArray = byteArray = baos.toByteArray();
            return byArray;
        }
    }

    public static String unweaveFrom(BufferedImage bufferedImage) {
        int width = bufferedImage.getWidth();
        int height = bufferedImage.getHeight();
        int messageLength = bufferedImage.getRGB(0, 0) & 0xFF;
        StringBuilder sb = new StringBuilder();
        int j = 0;
        int i = 1;
        for (int row = 0; row < height; ++row) {
            int column = 0;
            while (column < width && j < messageLength) {
                if (i % 11 == 0) {
                    int result = bufferedImage.getRGB(column, row);
                    int charAtPosition = (result >> 16 & 7) << 5;
                    charAtPosition |= (result >> 8 & 7) << 2;
                    sb.append((char)(charAtPosition |= result & 3));
                    ++j;
                }
                ++column;
                ++i;
            }
        }
        return sb.toString();
    }

    public static BufferedImage weaveInto(BufferedImage bufferedImage, String message) {
        int width = bufferedImage.getWidth();
        int height = bufferedImage.getHeight();
        if (message.length() > 255) {
            throw new IllegalArgumentException("Given message is to large(max 255 characters)");
        }
        if (message.length() * 11 > width * height) {
            throw new IllegalArgumentException("Given image is to small");
        }
        byte[] messageBytes = message.getBytes();
        int messageLengthDecode = bufferedImage.getRGB(0, 0) >> 8 << 8;
        bufferedImage.setRGB(0, 0, messageLengthDecode |= message.length());
        int i = 1;
        int messagePosition = 0;
        int j = 0;
        for (int row = 0; row < height; ++row) {
            int column = 0;
            while (column < width && j < messageBytes.length) {
                if (i % 11 == 0) {
                    int rgb = bufferedImage.getRGB(column, row);
                    int a = rgb >> 24 & 0xFF;
                    int r = (rgb >> 16 & 0xFF) >> 3 << 3;
                    int g = (rgb >> 8 & 0xFF) >> 3 << 3;
                    int b = (rgb & 0xFF) >> 2 << 2;
                    rgb = 0;
                    rgb |= a << 24;
                    rgb |= (r |= messageBytes[messagePosition] >> 5) << 16;
                    rgb |= (g |= messageBytes[messagePosition] >> 2 & 7) << 8;
                    bufferedImage.setRGB(column, row, rgb |= (b |= messageBytes[messagePosition] & 3));
                    ++messagePosition;
                    ++j;
                }
                ++column;
                ++i;
            }
        }
        return bufferedImage;
    }

    public static File write(BufferedImage bufferedImage, String formatName, File outputfile) throws IOException {
        ImageIO.write((RenderedImage)bufferedImage, formatName, outputfile);
        return outputfile;
    }
}

