/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.swing.dialog.factories;

import de.alpharogroup.swing.utils.AwtExtensions;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.Window;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import lombok.NonNull;

public final class JDialogFactory {
    public static JDialog newJDialog(Component parentComponent, String title, boolean modal, GraphicsConfiguration gc) {
        Window window = AwtExtensions.getWindowForComponent(parentComponent);
        JDialog dialog = window instanceof Frame ? new JDialog((Frame)window, title, modal, gc) : (window instanceof Dialog ? new JDialog((Dialog)window, title, modal, gc) : new JDialog((Frame)null, title, modal, gc));
        return dialog;
    }

    public static JDialog newJDialog(Component parentComponent, String title, Dialog.ModalityType modalityType, GraphicsConfiguration gc) {
        return new JDialog(AwtExtensions.getWindowForComponent(parentComponent), title, modalityType, gc);
    }

    public static JDialog newJDialog(@NonNull JOptionPane pane, String title) {
        if (pane == null) {
            throw new NullPointerException("pane is marked non-null but is null");
        }
        return JDialogFactory.newJDialog(null, pane, title);
    }

    public static JDialog newJDialog(Component parentComponent, @NonNull JOptionPane pane, String title) {
        if (pane == null) {
            throw new NullPointerException("pane is marked non-null but is null");
        }
        return parentComponent != null ? pane.createDialog(parentComponent, title) : pane.createDialog(title);
    }

    private JDialogFactory() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

