/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.swing.combobox.model;

import de.alpharogroup.swing.combobox.model.AbstractComboBoxModel;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import lombok.NonNull;

public class EnumComboBoxModel<E extends Enum<E>>
extends AbstractComboBoxModel<E> {
    private static final long serialVersionUID = 1L;
    private final Class<E> enumClass;
    private final Map<String, E> valueMap;

    public EnumComboBoxModel(@NonNull Class<E> enumClass) {
        super(EnumSet.allOf(enumClass));
        if (enumClass == null) {
            throw new NullPointerException("enumClass is marked non-null but is null");
        }
        this.enumClass = enumClass;
        this.valueMap = new HashMap<String, E>();
        this.initValueMap();
    }

    public EnumComboBoxModel(Class<E> enumClass, E selectedItem) {
        super(EnumSet.allOf(enumClass), selectedItem);
        this.enumClass = enumClass;
        this.valueMap = new HashMap<String, E>();
        this.initValueMap();
    }

    protected void initValueMap() {
        for (Enum enumValue : this.comboList) {
            this.valueMap.put(enumValue.name(), enumValue);
        }
    }

    @Override
    public void setSelectedItem(Object anItem) {
        Enum input = this.enumClass.isInstance(anItem) ? (Enum)anItem : (Enum)this.valueMap.get(anItem);
        if (input != null || anItem == null) {
            this.selectedItem = input;
        }
        this.fireContentsChanged(this, 0, this.getSize());
    }

    public Map<String, E> getValueMap() {
        return this.valueMap;
    }
}

