/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.swing.base;

import de.alpharogroup.model.api.Model;
import java.awt.LayoutManager;
import org.jdesktop.swingx.JXPanel;

public class BasePanel<T>
extends JXPanel {
    private static final long serialVersionUID = 1L;
    private Model<T> model;

    public BasePanel() {
        this.initialize();
    }

    public BasePanel(boolean isDoubleBuffered) {
        super(isDoubleBuffered);
        this.initialize();
    }

    public BasePanel(LayoutManager layout) {
        super(layout);
    }

    public BasePanel(LayoutManager layout, boolean isDoubleBuffered) {
        super(layout, isDoubleBuffered);
        this.initialize();
    }

    public BasePanel(Model<T> model) {
        this.model = model;
        this.initialize();
    }

    public final T getModelObject() {
        return (T)this.getModel().getObject();
    }

    private final void initialize() {
        this.onInitialize();
    }

    private final void initializeComponents() {
        this.onInitializeComponents();
    }

    private final void initializeLayout() {
        this.onInitializeLayout();
    }

    protected void onAfterInitialize() {
    }

    protected void onAfterInitializeComponents() {
    }

    protected void onAfterInitializeLayout() {
    }

    protected void onBeforeInitialize() {
    }

    protected void onBeforeInitializeComponents() {
    }

    protected void onBeforeInitializeLayout() {
    }

    protected void onInitialize() {
        this.onBeforeInitialize();
        this.onBeforeInitializeComponents();
        this.initializeComponents();
        this.onAfterInitializeComponents();
        this.onBeforeInitializeLayout();
        this.initializeLayout();
        this.onAfterInitializeLayout();
        this.onAfterInitialize();
    }

    protected void onInitializeComponents() {
    }

    protected void onInitializeLayout() {
    }

    public final BasePanel<T> setModelObject(T modelObject) {
        this.getModel().setObject(modelObject);
        return this;
    }

    public Model<T> getModel() {
        return this.model;
    }

    public BasePanel<T> setModel(Model<T> model) {
        this.model = model;
        return this;
    }

    public String toString() {
        return "BasePanel(model=" + this.getModel() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BasePanel)) {
            return false;
        }
        BasePanel other = (BasePanel)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Model<T> this$model = this.getModel();
        Model<T> other$model = other.getModel();
        return !(this$model == null ? other$model != null : !this$model.equals(other$model));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BasePanel;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Model<T> $model = this.getModel();
        result = result * 59 + ($model == null ? 43 : $model.hashCode());
        return result;
    }
}

