/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.swing.base;

import de.alpharogroup.model.api.Model;
import java.awt.GraphicsConfiguration;
import org.jdesktop.swingx.JXFrame;

public class BaseFrame<T>
extends JXFrame {
    private static final long serialVersionUID = 1L;
    private Model<T> model;

    public BaseFrame() {
        this.initialize();
    }

    public BaseFrame(GraphicsConfiguration gc) {
        super(gc);
        this.initialize();
    }

    public BaseFrame(Model<T> model) {
        this.model = model;
        this.initialize();
    }

    public BaseFrame(String title) {
        super(title);
        this.initialize();
    }

    public BaseFrame(String title, boolean exitOnClose) {
        super(title, exitOnClose);
        this.initialize();
    }

    public BaseFrame(String title, GraphicsConfiguration gc) {
        super(title, gc);
        this.initialize();
    }

    public BaseFrame(String title, GraphicsConfiguration gc, boolean exitOnClose) {
        super(title, gc, exitOnClose);
        this.initialize();
    }

    public BaseFrame(String title, GraphicsConfiguration gc, boolean exitOnClose, Model<T> model) {
        super(title, gc, exitOnClose);
        this.model = model;
        this.initialize();
    }

    public final T getModelObject() {
        return (T)this.getModel().getObject();
    }

    private final void initialize() {
        this.onInitialize();
    }

    private final void initializeComponents() {
        this.onInitializeComponents();
    }

    private final void initializeLayout() {
        this.onInitializeLayout();
    }

    protected void onAfterInitialize() {
    }

    protected void onAfterInitializeComponents() {
    }

    protected void onAfterInitializeLayout() {
    }

    protected void onBeforeInitialize() {
    }

    protected void onBeforeInitializeComponents() {
    }

    protected void onBeforeInitializeLayout() {
    }

    protected void onInitialize() {
        this.onBeforeInitialize();
        this.onBeforeInitializeComponents();
        this.initializeComponents();
        this.onAfterInitializeComponents();
        this.onBeforeInitializeLayout();
        this.initializeLayout();
        this.onAfterInitializeLayout();
        this.onAfterInitialize();
    }

    protected void onInitializeComponents() {
    }

    protected void onInitializeLayout() {
    }

    public final BaseFrame<T> setModelObject(T modelObject) {
        this.getModel().setObject(modelObject);
        return this;
    }

    public Model<T> getModel() {
        return this.model;
    }

    public BaseFrame<T> setModel(Model<T> model) {
        this.model = model;
        return this;
    }

    public String toString() {
        return "BaseFrame(model=" + this.getModel() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseFrame)) {
            return false;
        }
        BaseFrame other = (BaseFrame)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Model<T> this$model = this.getModel();
        Model<T> other$model = other.getModel();
        return !(this$model == null ? other$model != null : !this$model.equals(other$model));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BaseFrame;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Model<T> $model = this.getModel();
        result = result * 59 + ($model == null ? 43 : $model.hashCode());
        return result;
    }
}

