/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.swing.base;

import de.alpharogroup.swing.base.AbstractApplicationFrame;
import de.alpharogroup.swing.components.factories.JComponentFactory;
import de.alpharogroup.swing.desktoppane.SingletonDesktopPane;
import de.alpharogroup.swing.utils.JInternalFrameExtensions;
import java.awt.Component;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;

public abstract class ApplicationFrame<T>
extends AbstractApplicationFrame<T, JDesktopPane> {
    private static final long serialVersionUID = 1L;
    private JInternalFrame currentVisibleInternalFrame;

    public ApplicationFrame(String title) {
        super(title);
    }

    @Override
    protected JDesktopPane newMainComponent() {
        return SingletonDesktopPane.getInstance();
    }

    @Override
    protected void onInitializeComponents() {
        super.onInitializeComponents();
    }

    public void replaceInternalFrame(String title, Component component) {
        if (this.getCurrentVisibleInternalFrame() != null) {
            this.getCurrentVisibleInternalFrame().dispose();
        }
        JInternalFrame internalFrame = JComponentFactory.newInternalFrame(title, true, true, true, true);
        JInternalFrameExtensions.addComponentToFrame(internalFrame, component);
        JInternalFrameExtensions.addJInternalFrame((JDesktopPane)this.getMainComponent(), internalFrame);
        this.setCurrentVisibleInternalFrame(internalFrame);
    }

    public JInternalFrame getCurrentVisibleInternalFrame() {
        return this.currentVisibleInternalFrame;
    }

    public ApplicationFrame<T> setCurrentVisibleInternalFrame(JInternalFrame currentVisibleInternalFrame) {
        this.currentVisibleInternalFrame = currentVisibleInternalFrame;
        return this;
    }

    @Override
    public String toString() {
        return "ApplicationFrame(currentVisibleInternalFrame=" + this.getCurrentVisibleInternalFrame() + ")";
    }
}

