/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.swing.base;

import de.alpharogroup.lang.ClassExtensions;
import de.alpharogroup.layout.ScreenSizeExtensions;
import de.alpharogroup.swing.base.BaseDesktopMenu;
import de.alpharogroup.swing.base.BaseFrame;
import de.alpharogroup.swing.plaf.LookAndFeels;
import java.awt.Component;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JToolBar;
import javax.swing.UnsupportedLookAndFeelException;
import lombok.NonNull;

public abstract class AbstractApplicationFrame<T, C extends JComponent>
extends BaseFrame<T> {
    private static final Logger log = Logger.getLogger(AbstractApplicationFrame.class.getName());
    private static final long serialVersionUID = 1L;
    private File configurationDirectory;
    private LookAndFeels currentLookAndFeels = LookAndFeels.SYSTEM;
    private BufferedImage icon;
    private C mainComponent;
    private BaseDesktopMenu menu;
    private JToolBar toolbar;

    public AbstractApplicationFrame(String title) {
        super(title);
        this.configurationDirectory = this.newConfigurationDirectory(System.getProperty("user.home"), ".config");
    }

    protected Optional<BufferedImage> getIcon(@NonNull String iconPath) {
        if (iconPath == null) {
            throw new NullPointerException("iconPath is marked non-null but is null");
        }
        Optional<BufferedImage> optional = Optional.empty();
        try {
            BufferedImage bufferedImage = ImageIO.read(ClassExtensions.getResourceAsStream((String)iconPath));
            optional = Optional.of(bufferedImage);
        }
        catch (IOException e) {
            String title = e.getLocalizedMessage();
            String htmlMessage = "<html><body width='650'><h2>" + title + "</h2><p>" + e.getMessage();
            JOptionPane.showMessageDialog((Component)((Object)this), htmlMessage, title, 0);
            log.log(Level.SEVERE, e.getMessage(), e);
        }
        return optional;
    }

    protected File newConfigurationDirectory(@NonNull String parent, @NonNull String child) {
        if (parent == null) {
            throw new NullPointerException("parent is marked non-null but is null");
        }
        if (child == null) {
            throw new NullPointerException("child is marked non-null but is null");
        }
        File configurationDir = new File(parent, child);
        if (!configurationDir.exists()) {
            configurationDir.mkdir();
        }
        return configurationDir;
    }

    protected BaseDesktopMenu newDesktopMenu(@NonNull Component applicationFrame) {
        if (applicationFrame == null) {
            throw new NullPointerException("applicationFrame is marked non-null but is null");
        }
        return new BaseDesktopMenu(applicationFrame);
    }

    protected abstract String newIconPath();

    protected JToolBar newJToolBar() {
        return new JToolBar();
    }

    protected LookAndFeels newLookAndFeels() {
        return LookAndFeels.SYSTEM;
    }

    protected abstract C newMainComponent();

    @Override
    protected void onAfterInitialize() {
        super.onAfterInitialize();
        this.menu = this.newDesktopMenu((Component)((Object)this));
        this.setJMenuBar(this.menu.getMenubar());
        this.toolbar = this.newJToolBar();
        this.setToolBar(this.toolbar);
        this.mainComponent = this.newMainComponent();
        this.getContentPane().add((Component)this.mainComponent);
        Optional<BufferedImage> optionalIcon = this.getIcon(this.newIconPath());
        if (optionalIcon.isPresent()) {
            this.icon = optionalIcon.get();
            this.setIconImage(this.icon);
        }
        this.setDefaultCloseOperation(3);
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] gs = ge.getScreenDevices();
        this.setSize(ScreenSizeExtensions.getScreenWidth(gs[0]), ScreenSizeExtensions.getScreenHeight(gs[0]));
        this.setVisible(true);
        this.setDefaultLookAndFeel(this.newLookAndFeels(), (Component)((Object)this));
    }

    protected LookAndFeels setDefaultLookAndFeel(@NonNull LookAndFeels lookAndFeels, Component component) {
        if (lookAndFeels == null) {
            throw new NullPointerException("lookAndFeels is marked non-null but is null");
        }
        try {
            LookAndFeels.setLookAndFeel(lookAndFeels, component);
            this.setCurrentLookAndFeels(lookAndFeels);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException e) {
            String title = e.getLocalizedMessage();
            String htmlMessage = "<html><body width='650'><h2>" + title + "</h2><p>" + e.getMessage();
            JOptionPane.showMessageDialog((Component)((Object)this), htmlMessage, title, 0);
            log.log(Level.SEVERE, e.getMessage(), e);
        }
        return lookAndFeels;
    }

    @Override
    public String toString() {
        return "AbstractApplicationFrame(configurationDirectory=" + this.getConfigurationDirectory() + ", currentLookAndFeels=" + (Object)((Object)this.getCurrentLookAndFeels()) + ", icon=" + this.getIcon() + ", mainComponent=" + this.getMainComponent() + ", menu=" + this.getMenu() + ", toolbar=" + this.getToolbar() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractApplicationFrame)) {
            return false;
        }
        AbstractApplicationFrame other = (AbstractApplicationFrame)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        File this$configurationDirectory = this.getConfigurationDirectory();
        File other$configurationDirectory = other.getConfigurationDirectory();
        if (this$configurationDirectory == null ? other$configurationDirectory != null : !((Object)this$configurationDirectory).equals(other$configurationDirectory)) {
            return false;
        }
        LookAndFeels this$currentLookAndFeels = this.getCurrentLookAndFeels();
        LookAndFeels other$currentLookAndFeels = other.getCurrentLookAndFeels();
        if (this$currentLookAndFeels == null ? other$currentLookAndFeels != null : !((Object)((Object)this$currentLookAndFeels)).equals((Object)other$currentLookAndFeels)) {
            return false;
        }
        BufferedImage this$icon = this.getIcon();
        BufferedImage other$icon = other.getIcon();
        if (this$icon == null ? other$icon != null : !this$icon.equals(other$icon)) {
            return false;
        }
        C this$mainComponent = this.getMainComponent();
        C other$mainComponent = other.getMainComponent();
        if (this$mainComponent == null ? other$mainComponent != null : !this$mainComponent.equals(other$mainComponent)) {
            return false;
        }
        BaseDesktopMenu this$menu = this.getMenu();
        BaseDesktopMenu other$menu = other.getMenu();
        if (this$menu == null ? other$menu != null : !this$menu.equals(other$menu)) {
            return false;
        }
        JToolBar this$toolbar = this.getToolbar();
        JToolBar other$toolbar = other.getToolbar();
        return !(this$toolbar == null ? other$toolbar != null : !this$toolbar.equals(other$toolbar));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof AbstractApplicationFrame;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        File $configurationDirectory = this.getConfigurationDirectory();
        result = result * 59 + ($configurationDirectory == null ? 43 : ((Object)$configurationDirectory).hashCode());
        LookAndFeels $currentLookAndFeels = this.getCurrentLookAndFeels();
        result = result * 59 + ($currentLookAndFeels == null ? 43 : ((Object)((Object)$currentLookAndFeels)).hashCode());
        BufferedImage $icon = this.getIcon();
        result = result * 59 + ($icon == null ? 43 : $icon.hashCode());
        C $mainComponent = this.getMainComponent();
        result = result * 59 + ($mainComponent == null ? 43 : $mainComponent.hashCode());
        BaseDesktopMenu $menu = this.getMenu();
        result = result * 59 + ($menu == null ? 43 : $menu.hashCode());
        JToolBar $toolbar = this.getToolbar();
        result = result * 59 + ($toolbar == null ? 43 : $toolbar.hashCode());
        return result;
    }

    public File getConfigurationDirectory() {
        return this.configurationDirectory;
    }

    public LookAndFeels getCurrentLookAndFeels() {
        return this.currentLookAndFeels;
    }

    public AbstractApplicationFrame<T, C> setCurrentLookAndFeels(LookAndFeels currentLookAndFeels) {
        this.currentLookAndFeels = currentLookAndFeels;
        return this;
    }

    public BufferedImage getIcon() {
        return this.icon;
    }

    public C getMainComponent() {
        return this.mainComponent;
    }

    public BaseDesktopMenu getMenu() {
        return this.menu;
    }

    public JToolBar getToolbar() {
        return this.toolbar;
    }
}

