/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.layout;

import de.alpharogroup.layout.InsetsModel;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.io.Serializable;

public class GridBagLayoutModel
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final int anchor;
    private final int fill;
    private final GridBagConstraints gridBagConstraints;
    private final GridBagLayout gridBagLayout;
    private final int gridheight;
    private final int gridwidth;
    private final int gridx;
    private final int gridy;
    private final int horizontalStrut;
    private final InsetsModel insets;
    private final int ipadx;
    private final int ipady;
    private final Component layoutComponent;
    private final Container parent;
    private final int verticalStrut;
    private final double weightx;
    private final double weighty;

    public static GridBagLayoutModelBuilder builder() {
        return new GridBagLayoutModelBuilder();
    }

    public GridBagLayoutModelBuilder toBuilder() {
        return new GridBagLayoutModelBuilder().anchor(this.anchor).fill(this.fill).gridBagConstraints(this.gridBagConstraints).gridBagLayout(this.gridBagLayout).gridheight(this.gridheight).gridwidth(this.gridwidth).gridx(this.gridx).gridy(this.gridy).horizontalStrut(this.horizontalStrut).insets(this.insets).ipadx(this.ipadx).ipady(this.ipady).layoutComponent(this.layoutComponent).parent(this.parent).verticalStrut(this.verticalStrut).weightx(this.weightx).weighty(this.weighty);
    }

    public int getAnchor() {
        return this.anchor;
    }

    public int getFill() {
        return this.fill;
    }

    public GridBagConstraints getGridBagConstraints() {
        return this.gridBagConstraints;
    }

    public GridBagLayout getGridBagLayout() {
        return this.gridBagLayout;
    }

    public int getGridheight() {
        return this.gridheight;
    }

    public int getGridwidth() {
        return this.gridwidth;
    }

    public int getGridx() {
        return this.gridx;
    }

    public int getGridy() {
        return this.gridy;
    }

    public int getHorizontalStrut() {
        return this.horizontalStrut;
    }

    public InsetsModel getInsets() {
        return this.insets;
    }

    public int getIpadx() {
        return this.ipadx;
    }

    public int getIpady() {
        return this.ipady;
    }

    public Component getLayoutComponent() {
        return this.layoutComponent;
    }

    public Container getParent() {
        return this.parent;
    }

    public int getVerticalStrut() {
        return this.verticalStrut;
    }

    public double getWeightx() {
        return this.weightx;
    }

    public double getWeighty() {
        return this.weighty;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GridBagLayoutModel)) {
            return false;
        }
        GridBagLayoutModel other = (GridBagLayoutModel)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getAnchor() != other.getAnchor()) {
            return false;
        }
        if (this.getFill() != other.getFill()) {
            return false;
        }
        if (this.getGridheight() != other.getGridheight()) {
            return false;
        }
        if (this.getGridwidth() != other.getGridwidth()) {
            return false;
        }
        if (this.getGridx() != other.getGridx()) {
            return false;
        }
        if (this.getGridy() != other.getGridy()) {
            return false;
        }
        if (this.getHorizontalStrut() != other.getHorizontalStrut()) {
            return false;
        }
        if (this.getIpadx() != other.getIpadx()) {
            return false;
        }
        if (this.getIpady() != other.getIpady()) {
            return false;
        }
        if (this.getVerticalStrut() != other.getVerticalStrut()) {
            return false;
        }
        if (Double.compare(this.getWeightx(), other.getWeightx()) != 0) {
            return false;
        }
        if (Double.compare(this.getWeighty(), other.getWeighty()) != 0) {
            return false;
        }
        GridBagConstraints this$gridBagConstraints = this.getGridBagConstraints();
        GridBagConstraints other$gridBagConstraints = other.getGridBagConstraints();
        if (this$gridBagConstraints == null ? other$gridBagConstraints != null : !this$gridBagConstraints.equals(other$gridBagConstraints)) {
            return false;
        }
        GridBagLayout this$gridBagLayout = this.getGridBagLayout();
        GridBagLayout other$gridBagLayout = other.getGridBagLayout();
        if (this$gridBagLayout == null ? other$gridBagLayout != null : !this$gridBagLayout.equals(other$gridBagLayout)) {
            return false;
        }
        InsetsModel this$insets = this.getInsets();
        InsetsModel other$insets = other.getInsets();
        if (this$insets == null ? other$insets != null : !((Object)this$insets).equals(other$insets)) {
            return false;
        }
        Component this$layoutComponent = this.getLayoutComponent();
        Component other$layoutComponent = other.getLayoutComponent();
        if (this$layoutComponent == null ? other$layoutComponent != null : !this$layoutComponent.equals(other$layoutComponent)) {
            return false;
        }
        Container this$parent = this.getParent();
        Container other$parent = other.getParent();
        return !(this$parent == null ? other$parent != null : !this$parent.equals(other$parent));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GridBagLayoutModel;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getAnchor();
        result = result * 59 + this.getFill();
        result = result * 59 + this.getGridheight();
        result = result * 59 + this.getGridwidth();
        result = result * 59 + this.getGridx();
        result = result * 59 + this.getGridy();
        result = result * 59 + this.getHorizontalStrut();
        result = result * 59 + this.getIpadx();
        result = result * 59 + this.getIpady();
        result = result * 59 + this.getVerticalStrut();
        long $weightx = Double.doubleToLongBits(this.getWeightx());
        result = result * 59 + (int)($weightx >>> 32 ^ $weightx);
        long $weighty = Double.doubleToLongBits(this.getWeighty());
        result = result * 59 + (int)($weighty >>> 32 ^ $weighty);
        GridBagConstraints $gridBagConstraints = this.getGridBagConstraints();
        result = result * 59 + ($gridBagConstraints == null ? 43 : $gridBagConstraints.hashCode());
        GridBagLayout $gridBagLayout = this.getGridBagLayout();
        result = result * 59 + ($gridBagLayout == null ? 43 : $gridBagLayout.hashCode());
        InsetsModel $insets = this.getInsets();
        result = result * 59 + ($insets == null ? 43 : ((Object)$insets).hashCode());
        Component $layoutComponent = this.getLayoutComponent();
        result = result * 59 + ($layoutComponent == null ? 43 : $layoutComponent.hashCode());
        Container $parent = this.getParent();
        result = result * 59 + ($parent == null ? 43 : $parent.hashCode());
        return result;
    }

    public String toString() {
        return "GridBagLayoutModel(anchor=" + this.getAnchor() + ", fill=" + this.getFill() + ", gridBagConstraints=" + this.getGridBagConstraints() + ", gridBagLayout=" + this.getGridBagLayout() + ", gridheight=" + this.getGridheight() + ", gridwidth=" + this.getGridwidth() + ", gridx=" + this.getGridx() + ", gridy=" + this.getGridy() + ", horizontalStrut=" + this.getHorizontalStrut() + ", insets=" + this.getInsets() + ", ipadx=" + this.getIpadx() + ", ipady=" + this.getIpady() + ", layoutComponent=" + this.getLayoutComponent() + ", parent=" + this.getParent() + ", verticalStrut=" + this.getVerticalStrut() + ", weightx=" + this.getWeightx() + ", weighty=" + this.getWeighty() + ")";
    }

    public GridBagLayoutModel(int anchor, int fill, GridBagConstraints gridBagConstraints, GridBagLayout gridBagLayout, int gridheight, int gridwidth, int gridx, int gridy, int horizontalStrut, InsetsModel insets, int ipadx, int ipady, Component layoutComponent, Container parent, int verticalStrut, double weightx, double weighty) {
        this.anchor = anchor;
        this.fill = fill;
        this.gridBagConstraints = gridBagConstraints;
        this.gridBagLayout = gridBagLayout;
        this.gridheight = gridheight;
        this.gridwidth = gridwidth;
        this.gridx = gridx;
        this.gridy = gridy;
        this.horizontalStrut = horizontalStrut;
        this.insets = insets;
        this.ipadx = ipadx;
        this.ipady = ipady;
        this.layoutComponent = layoutComponent;
        this.parent = parent;
        this.verticalStrut = verticalStrut;
        this.weightx = weightx;
        this.weighty = weighty;
    }

    public static class GridBagLayoutModelBuilder {
        private int anchor;
        private int fill;
        private GridBagConstraints gridBagConstraints;
        private GridBagLayout gridBagLayout;
        private int gridheight;
        private int gridwidth;
        private int gridx;
        private int gridy;
        private int horizontalStrut;
        private InsetsModel insets;
        private int ipadx;
        private int ipady;
        private Component layoutComponent;
        private Container parent;
        private int verticalStrut;
        private double weightx;
        private double weighty;

        GridBagLayoutModelBuilder() {
        }

        public GridBagLayoutModelBuilder anchor(int anchor) {
            this.anchor = anchor;
            return this;
        }

        public GridBagLayoutModelBuilder fill(int fill) {
            this.fill = fill;
            return this;
        }

        public GridBagLayoutModelBuilder gridBagConstraints(GridBagConstraints gridBagConstraints) {
            this.gridBagConstraints = gridBagConstraints;
            return this;
        }

        public GridBagLayoutModelBuilder gridBagLayout(GridBagLayout gridBagLayout) {
            this.gridBagLayout = gridBagLayout;
            return this;
        }

        public GridBagLayoutModelBuilder gridheight(int gridheight) {
            this.gridheight = gridheight;
            return this;
        }

        public GridBagLayoutModelBuilder gridwidth(int gridwidth) {
            this.gridwidth = gridwidth;
            return this;
        }

        public GridBagLayoutModelBuilder gridx(int gridx) {
            this.gridx = gridx;
            return this;
        }

        public GridBagLayoutModelBuilder gridy(int gridy) {
            this.gridy = gridy;
            return this;
        }

        public GridBagLayoutModelBuilder horizontalStrut(int horizontalStrut) {
            this.horizontalStrut = horizontalStrut;
            return this;
        }

        public GridBagLayoutModelBuilder insets(InsetsModel insets) {
            this.insets = insets;
            return this;
        }

        public GridBagLayoutModelBuilder ipadx(int ipadx) {
            this.ipadx = ipadx;
            return this;
        }

        public GridBagLayoutModelBuilder ipady(int ipady) {
            this.ipady = ipady;
            return this;
        }

        public GridBagLayoutModelBuilder layoutComponent(Component layoutComponent) {
            this.layoutComponent = layoutComponent;
            return this;
        }

        public GridBagLayoutModelBuilder parent(Container parent) {
            this.parent = parent;
            return this;
        }

        public GridBagLayoutModelBuilder verticalStrut(int verticalStrut) {
            this.verticalStrut = verticalStrut;
            return this;
        }

        public GridBagLayoutModelBuilder weightx(double weightx) {
            this.weightx = weightx;
            return this;
        }

        public GridBagLayoutModelBuilder weighty(double weighty) {
            this.weighty = weighty;
            return this;
        }

        public GridBagLayoutModel build() {
            return new GridBagLayoutModel(this.anchor, this.fill, this.gridBagConstraints, this.gridBagLayout, this.gridheight, this.gridwidth, this.gridx, this.gridy, this.horizontalStrut, this.insets, this.ipadx, this.ipady, this.layoutComponent, this.parent, this.verticalStrut, this.weightx, this.weighty);
        }

        public String toString() {
            return "GridBagLayoutModel.GridBagLayoutModelBuilder(anchor=" + this.anchor + ", fill=" + this.fill + ", gridBagConstraints=" + this.gridBagConstraints + ", gridBagLayout=" + this.gridBagLayout + ", gridheight=" + this.gridheight + ", gridwidth=" + this.gridwidth + ", gridx=" + this.gridx + ", gridy=" + this.gridy + ", horizontalStrut=" + this.horizontalStrut + ", insets=" + this.insets + ", ipadx=" + this.ipadx + ", ipady=" + this.ipady + ", layoutComponent=" + this.layoutComponent + ", parent=" + this.parent + ", verticalStrut=" + this.verticalStrut + ", weightx=" + this.weightx + ", weighty=" + this.weighty + ")";
        }
    }
}

