/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.swing.tree;

import java.util.Enumeration;
import javax.swing.JTree;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import lombok.NonNull;

public class JTreeExtensions {
    public static void expandAll(JTree tree, TreePath path, boolean expand) {
        TreeNode node = (TreeNode)path.getLastPathComponent();
        if (node.getChildCount() >= 0) {
            Enumeration<? extends TreeNode> enumeration = node.children();
            while (enumeration.hasMoreElements()) {
                TreeNode n = enumeration.nextElement();
                TreePath p = path.pathByAddingChild(n);
                JTreeExtensions.expandAll(tree, p, expand);
            }
        }
        if (expand) {
            tree.expandPath(path);
        } else {
            tree.collapsePath(path);
        }
    }

    public static void expandNodes(@NonNull JTree tree) {
        if (tree == null) {
            throw new NullPointerException("tree is marked non-null but is null");
        }
        for (int i = 0; i < tree.getRowCount(); ++i) {
            tree.expandRow(i);
        }
    }
}

