/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.swing.table.model;

import de.alpharogroup.swing.table.model.GenericTableModel;
import de.alpharogroup.swing.table.model.TableColumnsModel;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class BaseTableModel<T>
extends GenericTableModel<T> {
    private static final Logger log = Logger.getLogger(BaseTableModel.class.getName());
    private static final long serialVersionUID = 1L;
    private TableColumnsModel columnsModel;

    public BaseTableModel(List<T> list) {
        super(list);
    }

    public BaseTableModel(List<T> list, TableColumnsModel columnsModel) {
        super(list);
        this.columnsModel = columnsModel;
    }

    public BaseTableModel(TableColumnsModel columnsModel) {
        this.columnsModel = columnsModel;
    }

    @Override
    public Class<?> getColumnClass(int c) {
        try {
            return this.columnsModel.getColumnClasses()[c];
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Error occured on getting column class on index " + c + ".", e);
            return null;
        }
    }

    @Override
    public int getColumnCount() {
        return this.columnsModel.getColumnNames().length;
    }

    @Override
    public String getColumnName(int col) {
        try {
            return this.columnsModel.getColumnNames()[col];
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Error occured on getting column name on index " + col + ".", e);
            return null;
        }
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        try {
            return this.columnsModel.getCanEdit()[columnIndex];
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Error occured on getting flag if the cell is editable at position on row: " + rowIndex + " and in column: " + columnIndex + ".", e);
            return false;
        }
    }

    public BaseTableModel() {
    }

    public TableColumnsModel getColumnsModel() {
        return this.columnsModel;
    }

    public BaseTableModel<T> setColumnsModel(TableColumnsModel columnsModel) {
        this.columnsModel = columnsModel;
        return this;
    }
}

