/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.swing.table.editor;

import java.awt.Component;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JTable;

public class TableCellButtonEditor
extends DefaultCellEditor {
    private static final long serialVersionUID = 1L;
    private JButton button;
    private boolean clicked;
    private int column;
    private int row;
    private Object value;

    public TableCellButtonEditor() {
        this(new JCheckBox());
    }

    public TableCellButtonEditor(JCheckBox checkBox) {
        super(checkBox);
        this.setButton(new JButton());
        this.getButton().setOpaque(true);
        this.getButton().addActionListener(e -> this.onClick());
    }

    @Override
    public Object getCellEditorValue() {
        this.setClicked(false);
        this.onGetCellEditorValue();
        return this.onSetText();
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.setRow(row);
        this.setColumn(column);
        this.setValue(value);
        if (isSelected) {
            this.getButton().setForeground(table.getSelectionForeground());
            this.getButton().setBackground(table.getSelectionBackground());
        } else {
            this.getButton().setForeground(table.getForeground());
            this.getButton().setBackground(table.getBackground());
        }
        this.getButton().setText(this.onSetText());
        this.setClicked(true);
        return this.getButton();
    }

    protected void onClick() {
        this.fireEditingStopped();
    }

    protected void onGetCellEditorValue() {
    }

    protected String onSetText() {
        String text = "";
        if (this.getValue() != null) {
            text = this.getValue().toString();
        }
        return text;
    }

    @Override
    public boolean stopCellEditing() {
        boolean stopCellEditing = super.stopCellEditing();
        this.setClicked(false);
        return stopCellEditing;
    }

    public JButton getButton() {
        return this.button;
    }

    public boolean isClicked() {
        return this.clicked;
    }

    public int getColumn() {
        return this.column;
    }

    public int getRow() {
        return this.row;
    }

    public Object getValue() {
        return this.value;
    }

    public TableCellButtonEditor setButton(JButton button) {
        this.button = button;
        return this;
    }

    public TableCellButtonEditor setClicked(boolean clicked) {
        this.clicked = clicked;
        return this;
    }

    public TableCellButtonEditor setColumn(int column) {
        this.column = column;
        return this;
    }

    public TableCellButtonEditor setRow(int row) {
        this.row = row;
        return this;
    }

    public TableCellButtonEditor setValue(Object value) {
        this.value = value;
        return this;
    }
}

