/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.swing.panels.lottery;

import de.alpharogroup.model.BaseModel;
import de.alpharogroup.model.api.Model;
import de.alpharogroup.swing.base.BasePanel;
import de.alpharogroup.swing.icon.StringIcon;
import de.alpharogroup.swing.panels.lottery.LotteryBox;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JComponent;

public class LotteryPanel
extends BasePanel<LotteryBox>
implements ActionListener {
    private LinkedHashMap<Integer, JCheckBox> lotteryBoxes;

    public LotteryPanel() {
        this((Model<LotteryBox>)BaseModel.of((Object)LotteryBox.builder().selectedNumbers(new LinkedHashSet<Integer>()).build()));
    }

    public LotteryPanel(Model<LotteryBox> model) {
        super(model);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        LinkedHashSet<Integer> selectedNumbers = ((LotteryBox)this.getModelObject()).getSelectedNumbers();
        JCheckBox source = (JCheckBox)e.getSource();
        boolean selected = source.isSelected();
        StringIcon icon = (StringIcon)source.getIcon();
        Integer selectedNumber = Integer.valueOf(icon.getText().trim());
        if (selected) {
            selectedNumbers.add(selectedNumber);
        } else {
            selectedNumbers.remove(selectedNumber);
        }
        if (selectedNumbers.size() == ((LotteryBox)this.getModelObject()).getMaxNumbers()) {
            this.lotteryBoxes.entrySet().stream().filter(entry -> !selectedNumbers.contains(entry.getKey())).map(Map.Entry::getValue).forEach(cb -> cb.setEnabled(false));
            this.revalidate();
        } else {
            this.lotteryBoxes.values().forEach(cb -> {
                if (!cb.isEnabled()) {
                    cb.setEnabled(true);
                }
            });
        }
    }

    @Override
    protected void onInitializeComponents() {
        this.lotteryBoxes = new LinkedHashMap();
        for (int i = ((LotteryBox)this.getModelObject()).getMinVolume(); i <= ((LotteryBox)this.getModelObject()).getMaxVolume(); i += ((LotteryBox)this.getModelObject()).getStep()) {
            StringIcon icon = new StringIcon((JComponent)((Object)this), Integer.valueOf(i).toString());
            JCheckBox checkBox = new JCheckBox(icon);
            checkBox.addActionListener(this);
            checkBox.setBorderPainted(true);
            this.lotteryBoxes.put(i, checkBox);
            this.add(checkBox);
        }
    }

    @Override
    protected void onInitializeLayout() {
        this.setLayout(new GridLayout(((LotteryBox)this.getModelObject()).getRows(), ((LotteryBox)this.getModelObject()).getColumns()));
    }
}

