/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.swing.list;

import de.alpharogroup.swing.check.model.CheckableItem;
import de.alpharogroup.swing.check.model.CheckableValue;
import de.alpharogroup.swing.tree.renderer.CheckBoxTreeCellRenderer;
import java.awt.Color;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;

public class CheckBoxListRenderer
extends CheckBoxTreeCellRenderer
implements ListCellRenderer<CheckableItem<CheckableValue>> {
    private static final long serialVersionUID = 1L;
    private Icon defaultIcon = UIManager.getIcon("Tree.leafIcon");
    private Color textBackground = UIManager.getColor("List.textBackground");
    private Color textForeground = UIManager.getColor("List.textForeground");

    public CheckBoxListRenderer() {
        this.getCheckBox().setBackground(this.textBackground);
        this.getLabel().setForeground(this.textForeground);
    }

    @Override
    public Component getListCellRendererComponent(JList<? extends CheckableItem<CheckableValue>> list, CheckableItem<CheckableValue> value, int index, boolean isSelected, boolean cellHasFocus) {
        this.setEnabled(list.isEnabled());
        this.getCheckBox().setSelected(value.isSelected());
        this.getLabel().setFont(list.getFont());
        this.getLabel().setText(value.getCheckableValue().getItemText());
        this.getLabel().setSelected(isSelected);
        this.getLabel().setFocused(cellHasFocus);
        Icon icon = value.getCheckableValue().getIcon();
        if (icon == null) {
            icon = this.defaultIcon;
        }
        this.getLabel().setIcon(icon);
        return this;
    }
}

