/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.swing.document.filter;

import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.DocumentFilter;

public class IntegerArrayFilter
extends DocumentFilter {
    @Override
    public void insertString(DocumentFilter.FilterBypass fb, int offset, String string, AttributeSet attr) throws BadLocationException {
        Document doc = fb.getDocument();
        StringBuilder sb = new StringBuilder();
        sb.append(doc.getText(0, doc.getLength()));
        sb.insert(offset, string);
        if (this.validate(sb.toString())) {
            super.insertString(fb, offset, string, attr);
        } else {
            this.onValidationError(sb.toString());
        }
    }

    public void onValidationError(String text) {
    }

    @Override
    public void remove(DocumentFilter.FilterBypass fb, int offset, int length) throws BadLocationException {
        Document doc = fb.getDocument();
        StringBuilder sb = new StringBuilder();
        sb.append(doc.getText(0, doc.getLength()));
        sb.delete(offset, offset + length);
        if (this.validate(sb.toString())) {
            super.remove(fb, offset, length);
        } else {
            this.onValidationError(sb.toString());
        }
    }

    @Override
    public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
        Document doc = fb.getDocument();
        StringBuilder sb = new StringBuilder();
        sb.append(doc.getText(0, doc.getLength()));
        sb.replace(offset, offset + length, text);
        if (this.validate(sb.toString())) {
            super.replace(fb, offset, length, text, attrs);
        } else {
            this.onValidationError(sb.toString());
        }
    }

    protected boolean validate(String text) {
        try {
            String[] strings = text.split(",");
            for (int i = 0; i < strings.length; ++i) {
                Integer.parseInt(strings[i].trim());
            }
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }
}

