/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.swing.base;

import de.alpharogroup.lang.ClassExtensions;
import de.alpharogroup.layout.ScreenSizeExtensions;
import de.alpharogroup.swing.base.BaseDesktopMenu;
import de.alpharogroup.swing.base.BaseFrame;
import de.alpharogroup.swing.plaf.LookAndFeels;
import java.awt.Component;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JToolBar;
import javax.swing.UnsupportedLookAndFeelException;
import lombok.NonNull;

public abstract class AbstractApplicationFrame<T, C extends JComponent>
extends BaseFrame<T> {
    private static final Logger log = Logger.getLogger(AbstractApplicationFrame.class.getName());
    private static final long serialVersionUID = 1L;
    private File configurationDirectory;
    private LookAndFeels currentLookAndFeels = LookAndFeels.SYSTEM;
    private BufferedImage icon;
    private C mainComponent;
    private BaseDesktopMenu menu;
    private JToolBar toolbar;

    public AbstractApplicationFrame(String title) {
        super(title);
        this.configurationDirectory = this.newConfigurationDirectory(System.getProperty("user.home"), ".config");
    }

    protected Optional<BufferedImage> getIcon(@NonNull String iconPath) {
        if (iconPath == null) {
            throw new NullPointerException("iconPath is marked non-null but is null");
        }
        Optional<BufferedImage> optional = Optional.empty();
        try {
            BufferedImage bufferedImage = ImageIO.read(ClassExtensions.getResourceAsStream((String)iconPath));
            optional = Optional.of(bufferedImage);
        }
        catch (IOException e) {
            String title = e.getLocalizedMessage();
            String htmlMessage = "<html><body width='650'><h2>" + title + "</h2><p>" + e.getMessage();
            JOptionPane.showMessageDialog((Component)((Object)this), htmlMessage, title, 0);
            log.log(Level.SEVERE, e.getMessage(), e);
        }
        return optional;
    }

    protected File newConfigurationDirectory(@NonNull String parent, @NonNull String child) {
        if (parent == null) {
            throw new NullPointerException("parent is marked non-null but is null");
        }
        if (child == null) {
            throw new NullPointerException("child is marked non-null but is null");
        }
        File configurationDir = new File(parent, child);
        if (!configurationDir.exists()) {
            configurationDir.mkdir();
        }
        return configurationDir;
    }

    protected BaseDesktopMenu newDesktopMenu(@NonNull Component applicationFrame) {
        if (applicationFrame == null) {
            throw new NullPointerException("applicationFrame is marked non-null but is null");
        }
        return new BaseDesktopMenu(applicationFrame);
    }

    protected abstract String newIconPath();

    protected JToolBar newJToolBar() {
        return new JToolBar();
    }

    protected LookAndFeels newLookAndFeels() {
        return LookAndFeels.SYSTEM;
    }

    protected abstract C newMainComponent();

    @Override
    protected void onAfterInitialize() {
        super.onAfterInitialize();
        this.menu = this.newDesktopMenu((Component)((Object)this));
        this.setJMenuBar(this.menu.getMenubar());
        this.toolbar = this.newJToolBar();
        this.setToolBar(this.toolbar);
        this.mainComponent = this.newMainComponent();
        this.getContentPane().add((Component)this.mainComponent);
        Optional<BufferedImage> optionalIcon = this.getIcon(this.newIconPath());
        if (optionalIcon.isPresent()) {
            this.icon = optionalIcon.get();
            this.setIconImage(this.icon);
        }
        this.setDefaultCloseOperation(3);
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] gs = ge.getScreenDevices();
        this.setSize(ScreenSizeExtensions.getScreenWidth(gs[0]), ScreenSizeExtensions.getScreenHeight(gs[0]));
        this.setVisible(true);
        this.setDefaultLookAndFeel(this.newLookAndFeels(), (Component)((Object)this));
    }

    protected LookAndFeels setDefaultLookAndFeel(@NonNull LookAndFeels lookAndFeels, Component component) {
        if (lookAndFeels == null) {
            throw new NullPointerException("lookAndFeels is marked non-null but is null");
        }
        try {
            LookAndFeels.setLookAndFeel(lookAndFeels, component);
            this.setCurrentLookAndFeels(lookAndFeels);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException e) {
            String title = e.getLocalizedMessage();
            String htmlMessage = "<html><body width='650'><h2>" + title + "</h2><p>" + e.getMessage();
            JOptionPane.showMessageDialog((Component)((Object)this), htmlMessage, title, 0);
            log.log(Level.SEVERE, e.getMessage(), e);
        }
        return lookAndFeels;
    }

    public File getConfigurationDirectory() {
        return this.configurationDirectory;
    }

    public LookAndFeels getCurrentLookAndFeels() {
        return this.currentLookAndFeels;
    }

    public AbstractApplicationFrame<T, C> setCurrentLookAndFeels(LookAndFeels currentLookAndFeels) {
        this.currentLookAndFeels = currentLookAndFeels;
        return this;
    }

    public BufferedImage getIcon() {
        return this.icon;
    }

    public C getMainComponent() {
        return this.mainComponent;
    }

    public BaseDesktopMenu getMenu() {
        return this.menu;
    }

    public JToolBar getToolbar() {
        return this.toolbar;
    }
}

