/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.swing.tree.renderer;

import de.alpharogroup.swing.components.factories.DimensionFactory;
import de.alpharogroup.swing.tree.labels.CheckBoxTreeLabel;
import de.alpharogroup.swing.tree.model.CheckableTreeNode;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.tree.TreeCellRenderer;

public class CheckBoxTreeCellRenderer
extends JPanel
implements TreeCellRenderer {
    private JCheckBox checkBox;
    private Icon closedIcon;
    private CheckBoxTreeLabel label;
    private Icon leafIcon;
    private Icon openIcon;
    private Color textBackground;
    private Color textForeground;

    public CheckBoxTreeCellRenderer() {
        this.setLayout(null);
        this.leafIcon = UIManager.getIcon("Tree.leafIcon");
        this.openIcon = UIManager.getIcon("Tree.openIcon");
        this.closedIcon = UIManager.getIcon("Tree.closedIcon");
        this.textBackground = UIManager.getColor("Tree.textBackground");
        this.textForeground = UIManager.getColor("Tree.textForeground");
        this.checkBox = this.newCheckBox();
        this.add(this.checkBox);
        this.label = this.newTreeLabel();
        this.add(this.label);
    }

    @Override
    public void doLayout() {
        Dimension checkboxDimension = this.checkBox.getPreferredSize();
        Dimension labelDimension = this.label.getPreferredSize();
        int yAxisCheckbox = 0;
        int yAxisLabel = 0;
        if (checkboxDimension.height < labelDimension.height) {
            yAxisCheckbox = (labelDimension.height - checkboxDimension.height) / 2;
        } else {
            yAxisLabel = (checkboxDimension.height - labelDimension.height) / 2;
        }
        this.checkBox.setLocation(0, yAxisCheckbox);
        this.checkBox.setBounds(0, yAxisCheckbox, checkboxDimension.width, checkboxDimension.height);
        this.label.setLocation(checkboxDimension.width, yAxisLabel);
        this.label.setBounds(checkboxDimension.width, yAxisLabel, labelDimension.width, labelDimension.height);
    }

    @Override
    public Dimension getPreferredSize() {
        return DimensionFactory.getPreferredSize(this.checkBox, this.label);
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        String stringValue = tree.convertValueToText(value, isSelected, expanded, leaf, row, hasFocus);
        this.setEnabled(tree.isEnabled());
        this.checkBox.setSelected(((CheckableTreeNode)value).isSelected());
        this.label.setFont(tree.getFont());
        this.label.setText(stringValue);
        this.label.setSelected(isSelected);
        this.label.setFocused(hasFocus);
        if (leaf) {
            this.label.setIcon(this.leafIcon);
        } else if (expanded) {
            this.label.setIcon(this.openIcon);
        } else {
            this.label.setIcon(this.closedIcon);
        }
        return this;
    }

    protected JCheckBox newCheckBox() {
        JCheckBox jCheckBox = new JCheckBox();
        jCheckBox.setBackground(this.textBackground);
        return jCheckBox;
    }

    protected CheckBoxTreeLabel newTreeLabel() {
        CheckBoxTreeLabel treeLabel = new CheckBoxTreeLabel();
        treeLabel.setForeground(this.textForeground);
        return treeLabel;
    }

    @Override
    public void setBackground(Color color) {
        if (color instanceof ColorUIResource) {
            color = null;
        }
        super.setBackground(color);
    }

    public JCheckBox getCheckBox() {
        return this.checkBox;
    }

    public Icon getClosedIcon() {
        return this.closedIcon;
    }

    public CheckBoxTreeLabel getLabel() {
        return this.label;
    }

    public Icon getLeafIcon() {
        return this.leafIcon;
    }

    public Icon getOpenIcon() {
        return this.openIcon;
    }

    public Color getTextBackground() {
        return this.textBackground;
    }

    public Color getTextForeground() {
        return this.textForeground;
    }
}

