/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.swing.panels.output;

import java.awt.EventQueue;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.JComponent;

public abstract class AbstractComponentOutputStream<T extends JComponent>
extends OutputStream {
    private Appender appender;
    private Lock jcosLock = new ReentrantLock();
    private byte[] oneByte;

    public AbstractComponentOutputStream(T component) {
        this(component, 100);
    }

    public AbstractComponentOutputStream(T component, int maxLines) {
        if (maxLines < 1) {
            throw new IllegalArgumentException("JComponentOutputStream maximum lines must be positive (value=" + maxLines + ")");
        }
        this.oneByte = new byte[1];
        this.appender = new Appender((JComponent)component, maxLines);
    }

    protected abstract void append(JComponent var1, String var2);

    private String bytesToString(byte[] ba, int str, int len) {
        try {
            return new String(ba, str, len, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException thr) {
            return new String(ba, str, len);
        }
    }

    public void clear() {
        this.jcosLock.lock();
        try {
            if (this.appender != null) {
                this.appender.clear();
            }
        }
        finally {
            this.jcosLock.unlock();
        }
    }

    @Override
    public void close() {
        this.jcosLock.lock();
        try {
            this.appender = null;
        }
        finally {
            this.jcosLock.unlock();
        }
    }

    @Override
    public void flush() {
    }

    protected abstract void replaceRange(JComponent var1, String var2, int var3, int var4);

    protected abstract void setText(JComponent var1, String var2);

    @Override
    public void write(byte[] ba) {
        this.jcosLock.lock();
        try {
            this.write(ba, 0, ba.length);
        }
        finally {
            this.jcosLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(byte[] ba, int str, int len) {
        this.jcosLock.lock();
        try {
            if (this.appender != null) {
                this.appender.append(this.bytesToString(ba, str, len));
            }
        }
        finally {
            this.jcosLock.unlock();
        }
    }

    @Override
    public void write(int val) {
        this.jcosLock.lock();
        try {
            this.oneByte[0] = (byte)val;
            this.write(this.oneByte, 0, 1);
        }
        finally {
            this.jcosLock.unlock();
        }
    }

    class Appender
    implements Runnable {
        private Lock appenderLock;
        private boolean clear;
        private int curLength;
        private final String EOL1 = "\n";
        private final String EOL2 = System.getProperty("line.separator", "\n");
        private final LinkedList<Integer> lengths;
        private final int maxLines;
        private boolean queue;
        private final JComponent swingComponent;
        private final List<String> values;

        Appender(JComponent cpt, int maxLines) {
            this.appenderLock = new ReentrantLock();
            this.swingComponent = cpt;
            this.maxLines = maxLines;
            this.lengths = new LinkedList();
            this.values = new ArrayList<String>();
            this.curLength = 0;
            this.clear = false;
            this.queue = true;
        }

        void append(String val) {
            this.appenderLock.lock();
            try {
                this.values.add(val);
                if (this.queue) {
                    this.queue = false;
                    EventQueue.invokeLater(this);
                }
            }
            finally {
                this.appenderLock.unlock();
            }
        }

        void clear() {
            this.appenderLock.lock();
            try {
                this.clear = true;
                this.curLength = 0;
                this.lengths.clear();
                this.values.clear();
                if (this.queue) {
                    this.queue = false;
                    EventQueue.invokeLater(this);
                }
            }
            finally {
                this.appenderLock.unlock();
            }
        }

        @Override
        public void run() {
            this.appenderLock.lock();
            try {
                if (this.clear) {
                    AbstractComponentOutputStream.this.setText(this.swingComponent, "");
                }
                for (String val : this.values) {
                    this.curLength += val.length();
                    if (val.endsWith("\n") || val.endsWith(this.EOL2)) {
                        if (this.lengths.size() >= this.maxLines) {
                            AbstractComponentOutputStream.this.replaceRange(this.swingComponent, "", 0, this.lengths.removeFirst());
                        }
                        this.lengths.addLast(this.curLength);
                        this.curLength = 0;
                    }
                    AbstractComponentOutputStream.this.append(this.swingComponent, val);
                }
                this.values.clear();
                this.clear = false;
                this.queue = true;
            }
            finally {
                this.appenderLock.unlock();
            }
        }
    }
}

