/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.swing.icon;

import de.alpharogroup.swing.icon.IconDimensions;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import lombok.NonNull;

public class StringIcon
implements Icon {
    private final JComponent component;
    private final Font font;
    private final Color foreground;
    private final IconDimensions iconDimensions;
    private final String text;

    public StringIcon(JComponent component, String text) {
        this(component, text, null, null);
    }

    public StringIcon(@NonNull JComponent component, @NonNull String text, Font font, Color foreground) {
        if (component == null) {
            throw new NullPointerException("component is marked non-null but is null");
        }
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        this.component = component;
        this.iconDimensions = IconDimensions.builder().build();
        this.font = font != null ? font : component.getFont();
        this.foreground = foreground != null ? foreground : component.getForeground();
        this.text = text;
        this.setIconDimensions(component.getFontMetrics(this.font), text, this.iconDimensions);
        component.revalidate();
    }

    @Override
    public int getIconHeight() {
        return this.iconDimensions.getIconHeight();
    }

    @Override
    public int getIconWidth() {
        return this.iconDimensions.getIconWidth();
    }

    private Graphics2D newGraphics2D(Graphics graphics) {
        Graphics2D graphics2d = (Graphics2D)graphics.create();
        Map map = (Map)Toolkit.getDefaultToolkit().getDesktopProperty("awt.font.desktophints");
        if (map != null) {
            graphics2d.addRenderingHints(map);
        } else {
            graphics2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        graphics2d.setFont(this.getFont());
        graphics2d.setColor(this.getForeground());
        return graphics2d;
    }

    @Override
    public void paintIcon(Component component, Graphics graphics, int x, int y) {
        Graphics2D graphics2d = this.newGraphics2D(graphics);
        FontMetrics fontMetrics = graphics2d.getFontMetrics();
        graphics2d.translate(x, y + fontMetrics.getAscent());
        graphics2d.drawString(this.text, this.iconDimensions.getPadding(), 0);
        graphics2d.dispose();
    }

    private IconDimensions setIconDimensions(FontMetrics fontMetrics, String text, IconDimensions iconDimensions) {
        iconDimensions.setIconWidth(fontMetrics.stringWidth(text) + iconDimensions.getPadding() * 2);
        iconDimensions.setIconHeight(fontMetrics.getHeight());
        return iconDimensions;
    }

    public JComponent getComponent() {
        return this.component;
    }

    public Font getFont() {
        return this.font;
    }

    public Color getForeground() {
        return this.foreground;
    }

    public IconDimensions getIconDimensions() {
        return this.iconDimensions;
    }

    public String getText() {
        return this.text;
    }
}

