/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.swing.base;

import de.alpharogroup.model.api.Model;
import java.awt.GraphicsConfiguration;
import org.jdesktop.swingx.JXFrame;

public class BaseFrame<T>
extends JXFrame {
    private static final long serialVersionUID = 1L;
    private Model<T> model;

    public BaseFrame() {
        this.initialize();
    }

    public BaseFrame(GraphicsConfiguration gc) {
        super(gc);
        this.initialize();
    }

    public BaseFrame(Model<T> model) {
        this.model = model;
        this.initialize();
    }

    public BaseFrame(String title) {
        super(title);
        this.initialize();
    }

    public BaseFrame(String title, boolean exitOnClose) {
        super(title, exitOnClose);
        this.initialize();
    }

    public BaseFrame(String title, GraphicsConfiguration gc) {
        super(title, gc);
        this.initialize();
    }

    public BaseFrame(String title, GraphicsConfiguration gc, boolean exitOnClose) {
        super(title, gc, exitOnClose);
        this.initialize();
    }

    public BaseFrame(String title, GraphicsConfiguration gc, boolean exitOnClose, Model<T> model) {
        super(title, gc, exitOnClose);
        this.model = model;
        this.initialize();
    }

    public final T getModelObject() {
        return (T)this.getModel().getObject();
    }

    private final void initialize() {
        this.onInitialize();
    }

    private final void initializeComponents() {
        this.onInitializeComponents();
    }

    private final void initializeLayout() {
        this.onInitializeLayout();
    }

    protected void onAfterInitialize() {
    }

    protected void onAfterInitializeComponents() {
    }

    protected void onAfterInitializeLayout() {
    }

    protected void onBeforeInitialize() {
    }

    protected void onBeforeInitializeComponents() {
    }

    protected void onBeforeInitializeLayout() {
    }

    protected void onInitialize() {
        this.onBeforeInitialize();
        this.onBeforeInitializeComponents();
        this.initializeComponents();
        this.onAfterInitializeComponents();
        this.onBeforeInitializeLayout();
        this.initializeLayout();
        this.onAfterInitializeLayout();
        this.onAfterInitialize();
    }

    protected void onInitializeComponents() {
    }

    protected void onInitializeLayout() {
    }

    public final BaseFrame<T> setModelObject(T modelObject) {
        this.getModel().setObject(modelObject);
        return this;
    }

    public Model<T> getModel() {
        return this.model;
    }

    public BaseFrame<T> setModel(Model<T> model) {
        this.model = model;
        return this;
    }
}

