/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.layout;

import de.alpharogroup.collections.array.ArrayExtensions;
import de.alpharogroup.reflection.ReflectionExtensions;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import javax.swing.JFrame;
import lombok.NonNull;

public class ScreenSizeExtensions {
    public static List<Point> computeDialogPositions(int dialogWidth, int dialogHeight) {
        ArrayList<Point> dialogPosition = null;
        int windowBesides = ScreenSizeExtensions.getScreenWidth() / dialogWidth;
        int windowBelow = ScreenSizeExtensions.getScreenHeight() / dialogHeight;
        int listSize = windowBesides * windowBelow;
        dialogPosition = new ArrayList<Point>(listSize);
        int dotWidth = 0;
        int dotHeight = 0;
        for (int y = 0; y < windowBelow; ++y) {
            dotWidth = 0;
            for (int x = 0; x < windowBesides; ++x) {
                Point p = new Point(dotWidth, dotHeight);
                dialogPosition.add(p);
                dotWidth += dialogWidth;
            }
            dotHeight += dialogHeight;
        }
        return dialogPosition;
    }

    public static int getFirstScreenHeight() {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] graphicsDevices = graphicsEnvironment.getScreenDevices();
        int height = ScreenSizeExtensions.getScreenHeight();
        for (GraphicsDevice graphicsDevice : graphicsDevices) {
            Object[] graphicsConfigurations = graphicsDevice.getConfigurations();
            GraphicsConfiguration graphicsConfiguration = (GraphicsConfiguration)ArrayExtensions.getFirst((Object[])graphicsConfigurations);
            if (graphicsConfiguration == null) continue;
            Rectangle bounds = graphicsConfiguration.getBounds();
            double h = bounds.getHeight();
            height = (int)h;
            break;
        }
        return height;
    }

    public static int getFirstScreenWidth() {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] graphicsDevices = graphicsEnvironment.getScreenDevices();
        int width = ScreenSizeExtensions.getScreenWidth();
        for (GraphicsDevice graphicsDevice : graphicsDevices) {
            Object[] graphicsConfigurations = graphicsDevice.getConfigurations();
            GraphicsConfiguration graphicsConfiguration = (GraphicsConfiguration)ArrayExtensions.getFirst((Object[])graphicsConfigurations);
            if (graphicsConfiguration == null) continue;
            Rectangle bounds = graphicsConfiguration.getBounds();
            double w = bounds.getWidth();
            width = (int)w;
            break;
        }
        return width;
    }

    public static Point getPoint() {
        Point p = new Point(ScreenSizeExtensions.getScreenWidth(), ScreenSizeExtensions.getScreenHeight());
        return p;
    }

    public static GraphicsDevice[] getScreenDevices() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] gs = ge.getScreenDevices();
        return gs;
    }

    public static Dimension getScreenDimension(Component component) {
        int screenID = ScreenSizeExtensions.getScreenID(component);
        Dimension dimension = new Dimension(0, 0);
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsConfiguration defaultConfiguration = ge.getScreenDevices()[screenID].getDefaultConfiguration();
        Rectangle rectangle = defaultConfiguration.getBounds();
        dimension.setSize(rectangle.getWidth(), rectangle.getHeight());
        return dimension;
    }

    public static int getScreenHeight() {
        int y = (int)Toolkit.getDefaultToolkit().getScreenSize().getHeight();
        return y;
    }

    public static int getScreenHeight(Component component) {
        Dimension dimension = ScreenSizeExtensions.getScreenDimension(component);
        return dimension.height;
    }

    public static int getScreenHeight(GraphicsDevice graphicsDevice) {
        Object[] graphicsConfigurations = graphicsDevice.getConfigurations();
        GraphicsConfiguration graphicsConfiguration = (GraphicsConfiguration)ArrayExtensions.getFirst((Object[])graphicsConfigurations);
        if (graphicsConfiguration != null) {
            Rectangle bounds = graphicsConfiguration.getBounds();
            double height = bounds.getHeight();
            return (int)height;
        }
        return ScreenSizeExtensions.getScreenHeight();
    }

    public static int getScreenID(Component component) {
        AtomicInteger counter = new AtomicInteger(-1);
        Stream.of(ScreenSizeExtensions.getScreenDevices()).forEach(graphicsDevice -> {
            GraphicsConfiguration gc = graphicsDevice.getDefaultConfiguration();
            Rectangle rectangle = gc.getBounds();
            if (rectangle.contains(component.getLocation())) {
                try {
                    Object object = ReflectionExtensions.getFieldValue((Object)graphicsDevice, (String)"screen");
                    Integer sid = (Integer)object;
                    counter.set(sid);
                }
                catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
                    e.printStackTrace();
                }
            }
        });
        int screenID = counter.get();
        return screenID;
    }

    public static int getScreenWidth() {
        int x = (int)Toolkit.getDefaultToolkit().getScreenSize().getWidth();
        return x;
    }

    public static int getScreenWidth(Component component) {
        Dimension dimension = ScreenSizeExtensions.getScreenDimension(component);
        return dimension.width;
    }

    public static int getScreenWidth(GraphicsDevice graphicsDevice) {
        Object[] graphicsConfigurations = graphicsDevice.getConfigurations();
        GraphicsConfiguration graphicsConfiguration = (GraphicsConfiguration)ArrayExtensions.getFirst((Object[])graphicsConfigurations);
        if (graphicsConfiguration != null) {
            Rectangle bounds = graphicsConfiguration.getBounds();
            double width = bounds.getWidth();
            return (int)width;
        }
        return ScreenSizeExtensions.getScreenWidth();
    }

    public static void toggleFullScreen(@NonNull JFrame frame) {
        if (frame == null) {
            throw new NullPointerException("frame is marked non-null but is null");
        }
        GraphicsDevice device = frame.getGraphicsConfiguration().getDevice();
        frame.setExtendedState(6);
        if (frame.equals(device.getFullScreenWindow())) {
            device.setFullScreenWindow(null);
        } else {
            frame.setVisible(true);
            device.setFullScreenWindow(frame);
        }
    }
}

