/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.swing.base;

import de.alpharogroup.lang.ClassExtensions;
import de.alpharogroup.swing.actions.OpenBrowserToDonateAction;
import de.alpharogroup.swing.actions.ShowInfoDialogAction;
import de.alpharogroup.swing.actions.ShowLicenseFrameAction;
import de.alpharogroup.swing.components.factories.JComponentFactory;
import de.alpharogroup.swing.dialog.info.InfoDialog;
import de.alpharogroup.swing.dialog.info.InfoPanel;
import de.alpharogroup.swing.menu.MenuExtensions;
import de.alpharogroup.swing.plaf.actions.LookAndFeelGTKAction;
import de.alpharogroup.swing.plaf.actions.LookAndFeelMetalAction;
import de.alpharogroup.swing.plaf.actions.LookAndFeelMotifAction;
import de.alpharogroup.swing.plaf.actions.LookAndFeelNimbusAction;
import de.alpharogroup.swing.plaf.actions.LookAndFeelSystemAction;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.help.CSH;
import javax.help.DefaultHelpBroker;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.help.HelpSetException;
import javax.help.WindowPresentation;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseDesktopMenu
extends JMenu {
    private static final Logger log = LoggerFactory.getLogger(BaseDesktopMenu.class);
    private static final long serialVersionUID = 1L;
    private final Component applicationFrame;
    private final JMenu fileMenu;
    private final DefaultHelpBroker helpBroker;
    private final JMenu helpMenu;
    private final Window helpWindow;
    private final JMenu lookAndFeelMenu;
    private final JMenuBar menubar;

    public BaseDesktopMenu(@NonNull Component applicationFrame) {
        if (applicationFrame == null) {
            throw new NullPointerException("applicationFrame is marked @NonNull but is null");
        }
        this.applicationFrame = applicationFrame;
        this.helpBroker = this.newHelpBroker();
        this.helpWindow = this.newHelpWindow(this.helpBroker);
        this.menubar = this.newJMenuBar();
        this.fileMenu = this.newFileMenu(e -> log.debug("filemenu"));
        this.menubar.add(this.fileMenu);
        this.lookAndFeelMenu = this.newLookAndFeelMenu(e -> log.debug("Look and Feel menu"));
        this.menubar.add(this.lookAndFeelMenu);
        this.helpMenu = this.newHelpMenu(e -> log.debug("Help menu"));
        this.menubar.add(this.helpMenu);
    }

    public HelpSet getHelpSet() {
        HelpSet hs = null;
        String filename = "simple-hs.xml";
        String path = "help/simple-hs.xml";
        URL hsURL = ClassExtensions.getResource((String)"help/simple-hs.xml");
        try {
            hs = new HelpSet(ClassExtensions.getClassLoader(), hsURL);
        }
        catch (HelpSetException e) {
            String title = e.getLocalizedMessage();
            String htmlMessage = "<html><body width='650'><h2>" + title + "</h2><p>" + e.getMessage();
            JOptionPane.showMessageDialog(this.getParent(), htmlMessage, title, 0);
            log.error(e.getMessage(), (Throwable)e);
        }
        return hs;
    }

    protected JMenu newFileMenu(ActionListener listener) {
        JMenu fileMenu = new JMenu("File");
        fileMenu.setMnemonic('F');
        return fileMenu;
    }

    protected DefaultHelpBroker newHelpBroker() {
        HelpSet hs = this.getHelpSet();
        DefaultHelpBroker helpBroker = (DefaultHelpBroker)hs.createHelpBroker();
        return helpBroker;
    }

    protected JMenu newHelpMenu(ActionListener listener) {
        JMenu menuHelp = new JMenu(this.newLabelTextHelp());
        menuHelp.setMnemonic('H');
        JMenuItem mihHelpContent = JComponentFactory.newJMenuItem(this.newLabelTextContent(), 99, 'H');
        menuHelp.add(mihHelpContent);
        CSH.setHelpIDString((Component)mihHelpContent, (String)this.newLabelTextOverview());
        CSH.DisplayHelpFromSource displayHelpFromSource = new CSH.DisplayHelpFromSource((HelpBroker)this.helpBroker);
        mihHelpContent.addActionListener((ActionListener)displayHelpFromSource);
        JMenuItem mihDonate = new JMenuItem(this.newLabelTextDonate());
        mihDonate.addActionListener(this.newOpenBrowserToDonateAction(this.newLabelTextDonate(), this.applicationFrame));
        menuHelp.add(mihDonate);
        JMenuItem mihLicence = new JMenuItem(this.newLabelTextLicence());
        mihLicence.addActionListener(this.newShowLicenseFrameAction(this.newLabelTextLicence() + "Action", this.newLabelTextLicence()));
        menuHelp.add(mihLicence);
        JMenuItem mihInfo = new JMenuItem(this.newLabelTextInfo(), 105);
        MenuExtensions.setCtrlAccelerator(mihInfo, 'I');
        mihInfo.addActionListener(this.newShowInfoDialogAction(this.newLabelTextInfo(), (Frame)this.applicationFrame, this.newLabelTextInfo()));
        menuHelp.add(mihInfo);
        return menuHelp;
    }

    protected Window newHelpWindow(DefaultHelpBroker helpBroker) {
        WindowPresentation pres = helpBroker.getWindowPresentation();
        pres.createHelpWindow();
        Window helpWindow = pres.getHelpWindow();
        helpWindow.setLocationRelativeTo(null);
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            String title = e.getLocalizedMessage();
            String htmlMessage = "<html><body width='650'><h2>" + title + "</h2><p>" + e.getMessage();
            JOptionPane.showMessageDialog(this.getParent(), htmlMessage, title, 0);
            log.error(e.getMessage(), (Throwable)e);
        }
        SwingUtilities.updateComponentTreeUI(helpWindow);
        return helpWindow;
    }

    protected JMenuBar newJMenuBar() {
        return new JMenuBar();
    }

    protected String newLabelTextApplicationName() {
        return "";
    }

    protected String newLabelTextContent() {
        return "Content";
    }

    protected String newLabelTextCopyright() {
        return "";
    }

    protected String newLabelTextDonate() {
        return "Donate";
    }

    protected String newLabelTextHelp() {
        return "Help";
    }

    protected String newLabelTextInfo() {
        return "Info";
    }

    protected String newLabelTextLabelApplicationName() {
        return "";
    }

    protected String newLabelTextLabelCopyright() {
        return "";
    }

    protected String newLabelTextLabelVersion() {
        return "";
    }

    protected String newLabelTextLicence() {
        return "Licence";
    }

    protected String newLabelTextOverview() {
        return "Overview";
    }

    protected String newLabelTextVersion() {
        return "";
    }

    protected JMenu newLookAndFeelMenu(ActionListener listener) {
        JMenu menuLookAndFeel = new JMenu("Look and Feel");
        menuLookAndFeel.setMnemonic('L');
        JMenuItem jmiPlafGTK = new JMenuItem("GTK", 103);
        MenuExtensions.setCtrlAccelerator(jmiPlafGTK, 'G');
        jmiPlafGTK.addActionListener(new LookAndFeelGTKAction("GTK", this.applicationFrame));
        menuLookAndFeel.add(jmiPlafGTK);
        JMenuItem jmiPlafMetal = new JMenuItem("Metal", 109);
        MenuExtensions.setCtrlAccelerator(jmiPlafMetal, 'M');
        jmiPlafMetal.addActionListener(new LookAndFeelMetalAction("Metal", this.applicationFrame));
        menuLookAndFeel.add(jmiPlafMetal);
        JMenuItem jmiPlafOcean = new JMenuItem("Ocean", 111);
        MenuExtensions.setCtrlAccelerator(jmiPlafOcean, 'O');
        jmiPlafOcean.addActionListener(new LookAndFeelMetalAction("Ocean", this.applicationFrame));
        menuLookAndFeel.add(jmiPlafOcean);
        JMenuItem jmiPlafMotiv = new JMenuItem("Motif", 116);
        MenuExtensions.setCtrlAccelerator(jmiPlafMotiv, 'T');
        jmiPlafMotiv.addActionListener(new LookAndFeelMotifAction("Motif", this.applicationFrame));
        menuLookAndFeel.add(jmiPlafMotiv);
        JMenuItem jmiPlafNimbus = new JMenuItem("Nimbus", 110);
        MenuExtensions.setCtrlAccelerator(jmiPlafNimbus, 'N');
        jmiPlafNimbus.addActionListener(new LookAndFeelNimbusAction("Nimbus", this.applicationFrame));
        menuLookAndFeel.add(jmiPlafNimbus);
        JMenuItem jmiPlafSystem = new JMenuItem("System", 100);
        MenuExtensions.setCtrlAccelerator(jmiPlafSystem, 'W');
        jmiPlafSystem.addActionListener(new LookAndFeelSystemAction("System", this.applicationFrame));
        menuLookAndFeel.add(jmiPlafSystem);
        return menuLookAndFeel;
    }

    protected OpenBrowserToDonateAction newOpenBrowserToDonateAction(String name, @NonNull Component component) {
        if (component == null) {
            throw new NullPointerException("component is marked @NonNull but is null");
        }
        return new OpenBrowserToDonateAction(name, component);
    }

    protected ShowInfoDialogAction newShowInfoDialogAction(String name, @NonNull Frame owner, @NonNull String title) {
        if (owner == null) {
            throw new NullPointerException("owner is marked @NonNull but is null");
        }
        if (title == null) {
            throw new NullPointerException("title is marked @NonNull but is null");
        }
        return new ShowInfoDialogAction(name, owner, title){

            @Override
            protected InfoDialog newInfoDialog(Frame owner, String title) {
                return BaseDesktopMenu.this.onNewInfoDialog(owner, title);
            }
        };
    }

    protected ShowLicenseFrameAction newShowLicenseFrameAction(String name, @NonNull String title) {
        if (title == null) {
            throw new NullPointerException("title is marked @NonNull but is null");
        }
        return new ShowLicenseFrameAction(name, title){

            @Override
            protected String newLicenseText() {
                return BaseDesktopMenu.this.onNewLicenseText();
            }
        };
    }

    protected String newTextWarning() {
        return "";
    }

    protected InfoDialog onNewInfoDialog(Frame owner, String title) {
        return new InfoDialog(owner, title){

            @Override
            protected InfoPanel newInfoPanel() {
                return new InfoPanel(){

                    @Override
                    protected String newLabelTextApplicationName() {
                        return BaseDesktopMenu.this.newLabelTextApplicationName();
                    }

                    @Override
                    protected String newLabelTextCopyright() {
                        return BaseDesktopMenu.this.newLabelTextCopyright();
                    }

                    @Override
                    protected String newLabelTextLabelApplicationName() {
                        return BaseDesktopMenu.this.newLabelTextLabelApplicationName();
                    }

                    @Override
                    protected String newLabelTextLabelCopyright() {
                        return BaseDesktopMenu.this.newLabelTextLabelCopyright();
                    }

                    @Override
                    protected String newLabelTextLabelVersion() {
                        return BaseDesktopMenu.this.newLabelTextLabelVersion();
                    }

                    @Override
                    protected String newLabelTextVersion() {
                        return BaseDesktopMenu.this.newLabelTextVersion();
                    }

                    @Override
                    protected String newTextWarning() {
                        return BaseDesktopMenu.this.newTextWarning();
                    }
                };
            }

            @Override
            protected String newLabelTextPlaceholder() {
                return "";
            }
        };
    }

    protected String onNewLicenseText() {
        return "Licence Text";
    }

    public Component getApplicationFrame() {
        return this.applicationFrame;
    }

    public JMenu getFileMenu() {
        return this.fileMenu;
    }

    public DefaultHelpBroker getHelpBroker() {
        return this.helpBroker;
    }

    public JMenu getHelpMenu() {
        return this.helpMenu;
    }

    public Window getHelpWindow() {
        return this.helpWindow;
    }

    public JMenu getLookAndFeelMenu() {
        return this.lookAndFeelMenu;
    }

    public JMenuBar getMenubar() {
        return this.menubar;
    }
}

