/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.swing.wizard;

import de.alpharogroup.design.pattern.state.wizard.model.WizardModelStateMachine;
import de.alpharogroup.model.BaseModel;
import de.alpharogroup.model.api.Model;
import de.alpharogroup.swing.base.BasePanel;
import de.alpharogroup.swing.wizard.BaseWizardContentPanel;
import de.alpharogroup.swing.wizard.NavigationPanel;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;

public abstract class AbstractWizardPanel<T>
extends BasePanel<T> {
    private static final long serialVersionUID = 1L;
    private NavigationPanel<WizardModelStateMachine<T>> navigationPanel;
    private WizardModelStateMachine<T> stateMachine;
    private BaseWizardContentPanel<T> wizardContentPanel;

    public AbstractWizardPanel() {
        this(BaseModel.of());
    }

    public AbstractWizardPanel(Model<T> model) {
        super(model);
    }

    protected NavigationPanel<WizardModelStateMachine<T>> newNavigationPanel(Model<WizardModelStateMachine<T>> model) {
        NavigationPanel navigationPanel = new NavigationPanel<WizardModelStateMachine<T>>(){
            private static final long serialVersionUID = 1L;

            @Override
            protected void onCancel() {
                AbstractWizardPanel.this.onCancel();
            }

            @Override
            protected void onFinish() {
                AbstractWizardPanel.this.onFinish();
            }

            @Override
            protected void onNext() {
                AbstractWizardPanel.this.onNext();
            }

            @Override
            protected void onPrevious() {
                AbstractWizardPanel.this.onPrevious();
            }
        };
        return navigationPanel;
    }

    protected abstract BaseWizardContentPanel<T> newWizardContentPanel(Model<WizardModelStateMachine<T>> var1);

    protected void onCancel() {
        this.stateMachine.cancel();
    }

    protected void onFinish() {
        this.stateMachine.finish();
    }

    @Override
    protected void onInitializeComponents() {
        super.onInitializeComponents();
        this.wizardContentPanel = this.newWizardContentPanel(BaseModel.of(this.getStateMachine()));
        this.navigationPanel = this.newNavigationPanel(BaseModel.of(this.getStateMachine()));
    }

    @Override
    protected void onInitializeLayout() {
        super.onInitializeLayout();
        this.setLayout(new BorderLayout());
        this.add((Component)((Object)this.wizardContentPanel), "Center");
        this.add((Component)((Object)this.navigationPanel), "South");
    }

    protected void onNext() {
        this.stateMachine.next();
        this.updateButtonState();
        String name = this.getStateMachine().getCurrentState().getName();
        CardLayout cardLayout = this.getWizardContentPanel().getCardLayout();
        cardLayout.show((Container)((Object)this.getWizardContentPanel()), name);
    }

    protected void onPrevious() {
        this.stateMachine.previous();
        this.updateButtonState();
        String name = this.getStateMachine().getCurrentState().getName();
        CardLayout cardLayout = this.getWizardContentPanel().getCardLayout();
        cardLayout.show((Container)((Object)this.getWizardContentPanel()), name);
    }

    protected void updateButtonState() {
        this.getNavigationPanel().getBtnPrevious().setEnabled(this.getStateMachine().getCurrentState().hasPrevious());
        this.getNavigationPanel().getBtnNext().setEnabled(this.getStateMachine().getCurrentState().hasNext());
    }

    public NavigationPanel<WizardModelStateMachine<T>> getNavigationPanel() {
        return this.navigationPanel;
    }

    public WizardModelStateMachine<T> getStateMachine() {
        return this.stateMachine;
    }

    public BaseWizardContentPanel<T> getWizardContentPanel() {
        return this.wizardContentPanel;
    }

    public void setNavigationPanel(NavigationPanel<WizardModelStateMachine<T>> navigationPanel) {
        this.navigationPanel = navigationPanel;
    }

    public void setStateMachine(WizardModelStateMachine<T> stateMachine) {
        this.stateMachine = stateMachine;
    }

    public void setWizardContentPanel(BaseWizardContentPanel<T> wizardContentPanel) {
        this.wizardContentPanel = wizardContentPanel;
    }
}

