/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.swing.table.editor;

import de.alpharogroup.swing.table.model.GenericTableModel;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JTable;
import javax.swing.table.TableModel;

public class DeleteRowButtonEditor
extends DefaultCellEditor {
    private static final long serialVersionUID = 1L;
    protected JButton button;
    private final DeleteRowButtonListener deleteRowButtonListener = new DeleteRowButtonListener();

    public DeleteRowButtonEditor(JCheckBox checkBox) {
        super(checkBox);
        this.button = new JButton();
        this.button.setOpaque(true);
        this.button.addActionListener(this.deleteRowButtonListener);
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.deleteRowButtonListener.setRow(row);
        this.deleteRowButtonListener.setTable(table);
        this.button.setText(value == null ? "" : "Delete");
        return this.button;
    }

    class DeleteRowButtonListener
    implements ActionListener {
        private int row;
        private JTable table;

        DeleteRowButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (this.table.getRowCount() > 0) {
                TableModel tableModel = this.table.getModel();
                GenericTableModel model = (GenericTableModel)tableModel;
                model.removeAt(this.row);
                DeleteRowButtonEditor.this.cancelCellEditing();
            }
        }

        public void setRow(int row) {
            this.row = row;
        }

        public void setTable(JTable table) {
            this.table = table;
        }
    }
}

