/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.swing.radio.model;

import de.alpharogroup.model.BaseModel;
import de.alpharogroup.model.api.Model;
import java.util.Map;
import javax.swing.JRadioButton;

public class EnumRadioButtonGroupBean<E extends Enum<E>> {
    private Map<E, JRadioButton> radioButtonMap;
    private Model<E> selected;

    public EnumRadioButtonGroupBean() {
        this(BaseModel.of());
    }

    public EnumRadioButtonGroupBean(Map<E, JRadioButton> radioButtonMap, Model<E> selected) {
        this.radioButtonMap = radioButtonMap;
        this.selected = selected;
    }

    public EnumRadioButtonGroupBean(Model<E> selected) {
        this.selected = selected;
    }

    public void associate(E enumValue, JRadioButton radioButton) {
        this.radioButtonMap.put(enumValue, radioButton);
    }

    public void associateMap(Map<E, JRadioButton> map) {
        this.radioButtonMap.putAll(map);
    }

    public Model<E> getSelected() {
        this.selected.setObject(this.getSelectedEnumFromRadioButtons());
        return this.selected;
    }

    public E getSelectedEnum() {
        return (E)((Enum)this.getSelected().getObject());
    }

    protected E getSelectedEnumFromRadioButtons() {
        for (Enum enumValue : this.radioButtonMap.keySet()) {
            JRadioButton btn = this.radioButtonMap.get(enumValue);
            if (!btn.isSelected()) continue;
            return (E)enumValue;
        }
        return null;
    }

    public E getValue() {
        this.selected.setObject(this.getSelectedEnumFromRadioButtons());
        return (E)((Enum)this.selected.getObject());
    }

    private void setSelectedRadioButton(E enumValue) {
        if (enumValue != null) {
            JRadioButton radioButton = this.radioButtonMap.get(enumValue);
            radioButton.setSelected(true);
        } else {
            for (JRadioButton radioButton : this.radioButtonMap.values()) {
                radioButton.setSelected(false);
            }
        }
    }

    public void setValue(E enumValue) {
        this.selected.setObject(enumValue);
        this.setSelectedRadioButton(enumValue);
    }

    public static <E extends Enum<E>> EnumRadioButtonGroupBeanBuilder<E> builder() {
        return new EnumRadioButtonGroupBeanBuilder();
    }

    public EnumRadioButtonGroupBeanBuilder<E> toBuilder() {
        return new EnumRadioButtonGroupBeanBuilder<E>().radioButtonMap(this.radioButtonMap).selected(this.selected);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EnumRadioButtonGroupBean)) {
            return false;
        }
        EnumRadioButtonGroupBean other = (EnumRadioButtonGroupBean)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<E, JRadioButton> this$radioButtonMap = this.radioButtonMap;
        Map<E, JRadioButton> other$radioButtonMap = other.radioButtonMap;
        if (this$radioButtonMap == null ? other$radioButtonMap != null : !((Object)this$radioButtonMap).equals(other$radioButtonMap)) {
            return false;
        }
        Model<E> this$selected = this.getSelected();
        Model<E> other$selected = other.getSelected();
        return !(this$selected == null ? other$selected != null : !this$selected.equals(other$selected));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EnumRadioButtonGroupBean;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<E, JRadioButton> $radioButtonMap = this.radioButtonMap;
        result = result * 59 + ($radioButtonMap == null ? 43 : ((Object)$radioButtonMap).hashCode());
        Model<E> $selected = this.getSelected();
        result = result * 59 + ($selected == null ? 43 : $selected.hashCode());
        return result;
    }

    public String toString() {
        return "EnumRadioButtonGroupBean(radioButtonMap=" + this.radioButtonMap + ", selected=" + this.getSelected() + ")";
    }

    public static class EnumRadioButtonGroupBeanBuilder<E extends Enum<E>> {
        private Map<E, JRadioButton> radioButtonMap;
        private Model<E> selected;

        EnumRadioButtonGroupBeanBuilder() {
        }

        public EnumRadioButtonGroupBeanBuilder<E> radioButtonMap(Map<E, JRadioButton> radioButtonMap) {
            this.radioButtonMap = radioButtonMap;
            return this;
        }

        public EnumRadioButtonGroupBeanBuilder<E> selected(Model<E> selected) {
            this.selected = selected;
            return this;
        }

        public EnumRadioButtonGroupBean<E> build() {
            return new EnumRadioButtonGroupBean<E>(this.radioButtonMap, this.selected);
        }

        public String toString() {
            return "EnumRadioButtonGroupBean.EnumRadioButtonGroupBeanBuilder(radioButtonMap=" + this.radioButtonMap + ", selected=" + this.selected + ")";
        }
    }
}

