/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.swing.combobox.model;

import de.alpharogroup.check.Argument;
import de.alpharogroup.collections.array.ArrayExtensions;
import de.alpharogroup.collections.list.ListExtensions;
import de.alpharogroup.collections.list.ListFactory;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;

public abstract class AbstractComboBoxModel<T>
extends AbstractListModel<T>
implements ComboBoxModel<T>,
ActionListener {
    private static final long serialVersionUID = 1L;
    protected List<T> comboList;
    protected T selectedItem;

    public AbstractComboBoxModel() {
        this(ListFactory.newArrayList((Object[])new Object[0]));
    }

    public AbstractComboBoxModel(List<T> comboList) {
        this(comboList, ListExtensions.getFirst(comboList));
    }

    public AbstractComboBoxModel(List<T> comboList, T selectedItem) {
        this.comboList = (List)Argument.notNull(comboList, (String)"comboList");
        this.selectedItem = selectedItem;
    }

    public AbstractComboBoxModel(Set<T> set) {
        this(ListExtensions.toList(set));
    }

    public AbstractComboBoxModel(Set<T> set, T selectedItem) {
        this(ListExtensions.toList(set), selectedItem);
    }

    public AbstractComboBoxModel(T[] comboArray) {
        this(ArrayExtensions.asList((Object[])comboArray));
    }

    public AbstractComboBoxModel(T[] comboArray, T selectedItem) {
        this(ArrayExtensions.asList((Object[])comboArray), selectedItem);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (evt.getActionCommand().equals("update")) {
            this.fireContentsChanged(this, 0, this.getSize() - 1);
        }
    }

    @Override
    public T getElementAt(int index) {
        return this.comboList.get(index);
    }

    @Override
    public int getSize() {
        return this.comboList.size();
    }

    public void setComboSet(Set<T> set) {
        this.setComboList(ListFactory.newArrayList(set, (Object[])new Object[0]));
    }

    @Override
    public void setSelectedItem(Object anItem) {
        this.selectedItem = anItem;
        this.fireContentsChanged(this, 0, this.getSize());
    }

    public List<T> getComboList() {
        return this.comboList;
    }

    @Override
    public T getSelectedItem() {
        return this.selectedItem;
    }

    public void setComboList(List<T> comboList) {
        this.comboList = comboList;
    }
}

