/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.swing.base;

import de.alpharogroup.lang.ClassExtensions;
import de.alpharogroup.layout.ScreenSizeExtensions;
import de.alpharogroup.swing.base.BaseDesktopMenu;
import de.alpharogroup.swing.base.BaseFrame;
import de.alpharogroup.swing.components.factories.JComponentFactory;
import de.alpharogroup.swing.desktoppane.SingletonDesktopPane;
import de.alpharogroup.swing.plaf.LookAndFeels;
import de.alpharogroup.swing.utils.JInternalFrameExtensions;
import java.awt.Component;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Optional;
import javax.imageio.ImageIO;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;
import javax.swing.JToolBar;
import javax.swing.UnsupportedLookAndFeelException;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ApplicationFrame<T>
extends BaseFrame<T> {
    private static final Logger log = LoggerFactory.getLogger(ApplicationFrame.class);
    private LookAndFeels currentLookAndFeels = LookAndFeels.SYSTEM;
    private JInternalFrame currentVisibleInternalFrame;
    private JDesktopPane desktopPane;
    private BufferedImage icon;
    private BaseDesktopMenu menu;
    private JToolBar toolbar;

    public ApplicationFrame(String title) {
        super(title);
    }

    protected Optional<BufferedImage> getIcon(@NonNull String iconPath) {
        if (iconPath == null) {
            throw new NullPointerException("iconPath is marked @NonNull but is null");
        }
        Optional<BufferedImage> optional = Optional.empty();
        try {
            BufferedImage bufferedImage = ImageIO.read(ClassExtensions.getResourceAsStream((String)iconPath));
            optional = Optional.of(bufferedImage);
        }
        catch (IOException e) {
            String title = e.getLocalizedMessage();
            String htmlMessage = "<html><body width='650'><h2>" + title + "</h2><p>" + e.getMessage();
            JOptionPane.showMessageDialog((Component)((Object)this), htmlMessage, title, 0);
            log.error(e.getMessage(), (Throwable)e);
        }
        return optional;
    }

    protected BaseDesktopMenu newDesktopMenu(@NonNull Component applicationFrame) {
        if (applicationFrame == null) {
            throw new NullPointerException("applicationFrame is marked @NonNull but is null");
        }
        return new BaseDesktopMenu(applicationFrame);
    }

    protected abstract String newIconPath();

    protected JDesktopPane newJDesktopPane() {
        return SingletonDesktopPane.getInstance();
    }

    protected JToolBar newJToolBar() {
        return new JToolBar();
    }

    protected LookAndFeels newLookAndFeels() {
        return LookAndFeels.SYSTEM;
    }

    @Override
    protected void onInitializeComponents() {
        super.onInitializeComponents();
        this.menu = this.newDesktopMenu((Component)((Object)this));
        this.setJMenuBar(this.menu.getMenubar());
        this.toolbar = this.newJToolBar();
        this.setToolBar(this.toolbar);
        this.desktopPane = this.newJDesktopPane();
        this.getContentPane().add(this.desktopPane);
        Optional<BufferedImage> optionalIcon = this.getIcon(this.newIconPath());
        if (optionalIcon.isPresent()) {
            this.icon = optionalIcon.get();
            this.setIconImage(this.icon);
        }
        this.setDefaultCloseOperation(3);
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] gs = ge.getScreenDevices();
        this.setSize(ScreenSizeExtensions.getScreenWidth(gs[0]), ScreenSizeExtensions.getScreenHeight(gs[0]));
        this.setVisible(true);
        this.setDefaultLookAndFeel(this.newLookAndFeels(), (Component)((Object)this));
    }

    public void replaceInternalFrame(String title, Component component) {
        if (this.getCurrentVisibleInternalFrame() != null) {
            this.getCurrentVisibleInternalFrame().dispose();
        }
        JInternalFrame internalFrame = JComponentFactory.newInternalFrame(title, true, true, true, true);
        JInternalFrameExtensions.addComponentToFrame(internalFrame, component);
        JInternalFrameExtensions.addJInternalFrame(this.desktopPane, internalFrame);
        this.setCurrentVisibleInternalFrame(internalFrame);
    }

    protected LookAndFeels setDefaultLookAndFeel(@NonNull LookAndFeels lookAndFeels, Component component) {
        if (lookAndFeels == null) {
            throw new NullPointerException("lookAndFeels is marked @NonNull but is null");
        }
        try {
            LookAndFeels.setLookAndFeel(lookAndFeels, component);
            this.setCurrentLookAndFeels(lookAndFeels);
        }
        catch (ClassNotFoundException e) {
            String title = e.getLocalizedMessage();
            String htmlMessage = "<html><body width='650'><h2>" + title + "</h2><p>" + e.getMessage();
            JOptionPane.showMessageDialog((Component)((Object)this), htmlMessage, title, 0);
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (InstantiationException e) {
            String title = e.getLocalizedMessage();
            String htmlMessage = "<html><body width='650'><h2>" + title + "</h2><p>" + e.getMessage();
            JOptionPane.showMessageDialog((Component)((Object)this), htmlMessage, title, 0);
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            String title = e.getLocalizedMessage();
            String htmlMessage = "<html><body width='650'><h2>" + title + "</h2><p>" + e.getMessage();
            JOptionPane.showMessageDialog((Component)((Object)this), htmlMessage, title, 0);
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (UnsupportedLookAndFeelException e) {
            String title = e.getLocalizedMessage();
            String htmlMessage = "<html><body width='650'><h2>" + title + "</h2><p>" + e.getMessage();
            JOptionPane.showMessageDialog((Component)((Object)this), htmlMessage, title, 0);
            log.error(e.getMessage(), (Throwable)e);
        }
        return lookAndFeels;
    }

    public LookAndFeels getCurrentLookAndFeels() {
        return this.currentLookAndFeels;
    }

    public void setCurrentLookAndFeels(LookAndFeels currentLookAndFeels) {
        this.currentLookAndFeels = currentLookAndFeels;
    }

    public JInternalFrame getCurrentVisibleInternalFrame() {
        return this.currentVisibleInternalFrame;
    }

    public void setCurrentVisibleInternalFrame(JInternalFrame currentVisibleInternalFrame) {
        this.currentVisibleInternalFrame = currentVisibleInternalFrame;
    }

    public JDesktopPane getDesktopPane() {
        return this.desktopPane;
    }

    public BufferedImage getIcon() {
        return this.icon;
    }

    public BaseDesktopMenu getMenu() {
        return this.menu;
    }

    public JToolBar getToolbar() {
        return this.toolbar;
    }
}

