/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.swing.actions;

import de.alpharogroup.swing.plaf.LookAndFeels;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShowHelpDialogAction
extends AbstractAction {
    private static final Logger log = LoggerFactory.getLogger(ShowHelpDialogAction.class);
    private static final long serialVersionUID = 1L;
    private final Window helpWindow;
    private final LookAndFeels lookAndFeels;

    public ShowHelpDialogAction(String name, @NonNull Window helpWindow, @NonNull LookAndFeels lookAndFeels) {
        super(name);
        if (helpWindow == null) {
            throw new NullPointerException("helpWindow is marked @NonNull but is null");
        }
        if (lookAndFeels == null) {
            throw new NullPointerException("lookAndFeels is marked @NonNull but is null");
        }
        this.helpWindow = helpWindow;
        this.lookAndFeels = lookAndFeels;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.helpWindow.setLocationRelativeTo(null);
        try {
            UIManager.setLookAndFeel(this.lookAndFeels.getLookAndFeelName());
        }
        catch (Exception ex) {
            log.error(ex.getLocalizedMessage(), (Throwable)ex);
        }
        SwingUtilities.updateComponentTreeUI(this.helpWindow);
    }

    public Window getHelpWindow() {
        return this.helpWindow;
    }

    public LookAndFeels getLookAndFeels() {
        return this.lookAndFeels;
    }
}

