/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.layout;

import de.alpharogroup.collections.array.ArrayExtensions;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.util.ArrayList;
import java.util.List;

public class ScreenSizeExtensions {
    public static List<Point> computeDialogPositions(int dialogWidth, int dialogHeight) {
        ArrayList<Point> dialogPosition = null;
        int windowBesides = ScreenSizeExtensions.getScreenWidth() / dialogWidth;
        int windowBelow = ScreenSizeExtensions.getScreenHeight() / dialogHeight;
        int listSize = windowBesides * windowBelow;
        dialogPosition = new ArrayList<Point>(listSize);
        int dotWidth = 0;
        int dotHeight = 0;
        for (int y = 0; y < windowBelow; ++y) {
            dotWidth = 0;
            for (int x = 0; x < windowBesides; ++x) {
                Point p = new Point(dotWidth, dotHeight);
                dialogPosition.add(p);
                dotWidth += dialogWidth;
            }
            dotHeight += dialogHeight;
        }
        return dialogPosition;
    }

    public static int getFirstScreenHeight() {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] graphicsDevices = graphicsEnvironment.getScreenDevices();
        int height = ScreenSizeExtensions.getScreenHeight();
        for (GraphicsDevice graphicsDevice : graphicsDevices) {
            Object[] graphicsConfigurations = graphicsDevice.getConfigurations();
            GraphicsConfiguration graphicsConfiguration = (GraphicsConfiguration)ArrayExtensions.getFirst((Object[])graphicsConfigurations);
            if (graphicsConfiguration == null) continue;
            Rectangle bounds = graphicsConfiguration.getBounds();
            double h = bounds.getHeight();
            height = (int)h;
            break;
        }
        return height;
    }

    public static int getFirstScreenWidth() {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] graphicsDevices = graphicsEnvironment.getScreenDevices();
        int width = ScreenSizeExtensions.getScreenWidth();
        for (GraphicsDevice graphicsDevice : graphicsDevices) {
            Object[] graphicsConfigurations = graphicsDevice.getConfigurations();
            GraphicsConfiguration graphicsConfiguration = (GraphicsConfiguration)ArrayExtensions.getFirst((Object[])graphicsConfigurations);
            if (graphicsConfiguration == null) continue;
            Rectangle bounds = graphicsConfiguration.getBounds();
            double w = bounds.getWidth();
            width = (int)w;
            break;
        }
        return width;
    }

    public static Point getPoint() {
        Point p = new Point(ScreenSizeExtensions.getScreenWidth(), ScreenSizeExtensions.getScreenHeight());
        return p;
    }

    public static GraphicsDevice[] getScreenDevices() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] gs = ge.getScreenDevices();
        return gs;
    }

    public static int getScreenHeight() {
        int y = (int)Toolkit.getDefaultToolkit().getScreenSize().getHeight();
        return y;
    }

    public static int getScreenHeight(GraphicsDevice graphicsDevice) {
        Object[] graphicsConfigurations = graphicsDevice.getConfigurations();
        GraphicsConfiguration graphicsConfiguration = (GraphicsConfiguration)ArrayExtensions.getFirst((Object[])graphicsConfigurations);
        if (graphicsConfiguration != null) {
            Rectangle bounds = graphicsConfiguration.getBounds();
            double height = bounds.getHeight();
            return (int)height;
        }
        return ScreenSizeExtensions.getScreenHeight();
    }

    public static int getScreenWidth() {
        int x = (int)Toolkit.getDefaultToolkit().getScreenSize().getWidth();
        return x;
    }

    public static int getScreenWidth(GraphicsDevice graphicsDevice) {
        Object[] graphicsConfigurations = graphicsDevice.getConfigurations();
        GraphicsConfiguration graphicsConfiguration = (GraphicsConfiguration)ArrayExtensions.getFirst((Object[])graphicsConfigurations);
        if (graphicsConfiguration != null) {
            Rectangle bounds = graphicsConfiguration.getBounds();
            double width = bounds.getWidth();
            return (int)width;
        }
        return ScreenSizeExtensions.getScreenWidth();
    }
}

