/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.generic.mvc.controller;

import de.alpharogroup.generic.mvc.controller.Controller;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;

public abstract class AbstractGenericController<M, V>
implements Controller<M, V>,
ActionListener {
    private Map<String, Controller<M, V>> children;
    private M model;
    private Controller<M, V> parent;
    private V view;

    public AbstractGenericController() {
        this.initialize();
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        this.process(event);
    }

    @Override
    public Controller<M, V> getChild(String key) {
        return this.children.get(key);
    }

    @Override
    public Map<String, Controller<M, V>> getChildren() {
        return this.children;
    }

    @Override
    public M getModel() {
        return this.model;
    }

    @Override
    public String getName() {
        return this.getClass().getName();
    }

    @Override
    public Controller<M, V> getParent() {
        return this.parent;
    }

    @Override
    public V getView() {
        return this.view;
    }

    @Override
    public boolean hasChild(Controller<M, V> controller) {
        return this.children.containsValue(controller);
    }

    @Override
    public boolean hasChild(String key) {
        return this.children.containsKey(key);
    }

    protected void initialize() {
        this.preinitialize();
        this.postinitialize();
    }

    protected void postinitialize() {
    }

    protected void preinitialize() {
    }

    @Override
    public abstract void process(ActionEvent var1);

    @Override
    public Controller<M, V> removeChild(Controller<M, V> controller) {
        return this.removeChild(controller.getName());
    }

    @Override
    public Controller<M, V> removeChild(String key) {
        return this.children.remove(key);
    }

    @Override
    public Object setChild(String key, Controller<M, V> controller) {
        if (null != controller.getParent()) {
            // empty if block
        }
        return this.children.put(key, controller);
    }

    @Override
    public void setModel(M model) {
        this.model = model;
    }

    @Override
    public void setParent(Controller<M, V> controller) {
        this.parent = controller;
    }

    @Override
    public void setView(V view) {
        this.view = view;
    }
}

