/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.swing.tablemodel;

import de.alpharogroup.swing.tablemodel.GenericTableModel;
import de.alpharogroup.swing.tablemodel.TableColumnsModel;
import java.util.List;

public abstract class BaseTableModel<T>
extends GenericTableModel<T> {
    private static final long serialVersionUID = 1L;
    private TableColumnsModel columnsModel;

    public BaseTableModel() {
    }

    public BaseTableModel(List<T> list) {
        super(list);
    }

    public BaseTableModel(TableColumnsModel columnsModel) {
        this.columnsModel = columnsModel;
    }

    @Override
    public Class<?> getColumnClass(int c) {
        try {
            return this.columnsModel.getColumnClasses()[c];
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public int getColumnCount() {
        return this.columnsModel.getColumnNames().length;
    }

    @Override
    public String getColumnName(int col) {
        try {
            return this.columnsModel.getColumnNames()[col];
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        try {
            return this.columnsModel.getCanEdit()[columnIndex];
        }
        catch (Exception e) {
            return false;
        }
    }

    public TableColumnsModel getColumnsModel() {
        return this.columnsModel;
    }

    public void setColumnsModel(TableColumnsModel columnsModel) {
        this.columnsModel = columnsModel;
    }
}

