/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.swing.browser;

import java.util.regex.Pattern;

public enum OS {
    WINDOWS("Windows"),
    MAC("Mac OS"),
    LINUX("Linux"),
    UNIX("Unix"),
    OTHER("Other");

    private static final String OS_NAME = "os.name";
    private static final Pattern LINUX_PATTERN;
    private static final Pattern WINDOWS_PATTERN;
    private static final Pattern MAC_PATTERN;
    private final String os;

    public static OS get() {
        return OS.getOperatingSystem();
    }

    public static OS getOperatingSystem() {
        String osname = System.getProperty(OS_NAME);
        if (WINDOWS_PATTERN.matcher(osname).matches()) {
            return WINDOWS;
        }
        if (LINUX_PATTERN.matcher(osname).matches()) {
            return LINUX;
        }
        if (MAC_PATTERN.matcher(osname).matches()) {
            return MAC;
        }
        return OTHER;
    }

    private OS(String os) {
        this.os = os;
    }

    public String getOs() {
        return this.os;
    }

    static {
        LINUX_PATTERN = Pattern.compile(".*[L|l]inux.*");
        WINDOWS_PATTERN = Pattern.compile(".*[W|w]indows.*");
        MAC_PATTERN = Pattern.compile("mac|darwin");
    }
}

