/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.swing.base;

import de.alpharogroup.model.api.Model;
import java.awt.LayoutManager;
import org.jdesktop.swingx.JXPanel;

public class BasePanel<T>
extends JXPanel {
    private static final long serialVersionUID = 1L;
    private Model<T> model;

    public BasePanel() {
        this.initialize();
    }

    public BasePanel(boolean isDoubleBuffered) {
        super(isDoubleBuffered);
        this.initialize();
    }

    public BasePanel(LayoutManager layout) {
        super(layout);
    }

    public BasePanel(LayoutManager layout, boolean isDoubleBuffered) {
        super(layout, isDoubleBuffered);
        this.initialize();
    }

    public BasePanel(Model<T> model) {
        this.model = model;
        this.initialize();
    }

    public final T getModelObject() {
        return (T)this.getModel().getObject();
    }

    protected final void initialize() {
        this.onInitialize();
    }

    protected final void initializeComponents() {
        this.onInitializeComponents();
    }

    protected final void initializeLayout() {
        this.onInitializeLayout();
    }

    protected void onAfterInitialize() {
    }

    protected void onAfterInitializeComponents() {
    }

    protected void onAfterInitializeLayout() {
    }

    protected void onBeforeInitialize() {
    }

    protected void onBeforeInitializeComponents() {
    }

    protected void onBeforeInitializeLayout() {
    }

    protected void onInitialize() {
        this.onBeforeInitialize();
        this.onBeforeInitializeComponents();
        this.initializeComponents();
        this.onAfterInitializeComponents();
        this.onBeforeInitializeLayout();
        this.initializeLayout();
        this.onAfterInitializeLayout();
        this.onAfterInitialize();
    }

    protected void onInitializeComponents() {
    }

    protected void onInitializeLayout() {
    }

    public final BasePanel<T> setModelObject(T modelObject) {
        this.getModel().setObject(modelObject);
        return this;
    }

    public Model<T> getModel() {
        return this.model;
    }

    public void setModel(Model<T> model) {
        this.model = model;
    }
}

