/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.swing;

import de.alpharogroup.check.Check;
import de.alpharogroup.swing.tablemodel.GenericTableModel;
import javax.swing.JTable;
import javax.swing.table.TableRowSorter;

public class GenericJTable<T>
extends JTable {
    private static final long serialVersionUID = 1L;
    private final GenericTableModel<T> genericTableModel;
    private final TableRowSorter<GenericTableModel<T>> sorter;

    public GenericJTable(GenericTableModel<T> genericTableModel) {
        super(genericTableModel);
        Check.get().notNull(genericTableModel, "genericTableModel");
        this.genericTableModel = genericTableModel;
        this.setModel(this.genericTableModel);
        this.sorter = new TableRowSorter<GenericTableModel<T>>(this.genericTableModel);
        this.setRowSorter(this.sorter);
    }

    @Override
    public int getSelectedRow() {
        int selectedRow = super.getSelectedRow();
        if (-1 < selectedRow) {
            selectedRow = this.convertRowIndexToModel(selectedRow);
        }
        return selectedRow;
    }

    @Override
    public int[] getSelectedRows() {
        int[] selectedRows = super.getSelectedRows();
        int[] sr = new int[selectedRows.length];
        for (int i = 0; i < selectedRows.length; ++i) {
            sr[i] = this.convertRowIndexToModel(selectedRows[i]);
        }
        return sr;
    }

    public boolean isAnyRowSelected() {
        return -1 < super.getSelectedRow();
    }

    public GenericTableModel<T> getGenericTableModel() {
        return this.genericTableModel;
    }

    public TableRowSorter<GenericTableModel<T>> getSorter() {
        return this.sorter;
    }
}

