/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.swing.browser;

import de.alpharogroup.swing.browser.Browsers;
import de.alpharogroup.swing.browser.OS;
import java.awt.Component;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import javax.swing.JOptionPane;

public class BrowserControlExtensions {
    private static final String MAC_FILE_MANAGER = "com.apple.eio.FileManager";
    private static final String UNIX_COMMAND_WHICH = "which";
    private static final String SYSTEM_PROPERTY_OS_NAME = "os.name";
    private static final String WINDOWS_PATH = "rundll32";
    private static final String WINDOWS_FLAG = "url.dll,FileProtocolHandler";

    public static Object displayURLonStandardBrowser(Component parentComponent, String url) {
        Object obj = null;
        try {
            obj = System.getProperty(SYSTEM_PROPERTY_OS_NAME).startsWith(OS.MAC.getOs()) ? BrowserControlExtensions.openURLinMacOS(url) : (System.getProperty(SYSTEM_PROPERTY_OS_NAME).startsWith(OS.WINDOWS.getOs()) ? BrowserControlExtensions.openURLinWindowsOS(url) : BrowserControlExtensions.openURLinUnixOS(url));
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(parentComponent, "An exception occured attempting to run the default web browser\n" + e.toString());
        }
        return obj;
    }

    private static Object openURLinMacOS(String url) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Class<?> fileManagerClass = Class.forName(MAC_FILE_MANAGER);
        Method openURL = fileManagerClass.getDeclaredMethod("openURL", String.class);
        return openURL.invoke(null, url);
    }

    private static Boolean openURLinUnixOS(String url) throws InterruptedException, IOException, Exception {
        Boolean executed = false;
        for (Browsers browser : Browsers.values()) {
            if (executed.booleanValue() || !(executed = Boolean.valueOf(Runtime.getRuntime().exec(new String[]{UNIX_COMMAND_WHICH, browser.getBrowserName()}).waitFor() == 0)).booleanValue()) continue;
            Runtime.getRuntime().exec(new String[]{browser.getBrowserName(), url});
        }
        if (!executed.booleanValue()) {
            throw new Exception(Arrays.toString((Object[])Browsers.values()));
        }
        return executed;
    }

    private static Process openURLinWindowsOS(String url) throws IOException {
        String cmd = null;
        cmd = "rundll32 url.dll,FileProtocolHandler ";
        return Runtime.getRuntime().exec(cmd + url);
    }
}

