/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.layout;

import de.alpharogroup.lang.ObjectExtensions;
import de.alpharogroup.layout.GridBagLayoutModel;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.Box;

public final class LayoutExtensions {
    public static void add(GridBagLayoutModel layoutModel) {
        GridBagConstraints gbc = layoutModel.getGridBagConstraints();
        Component layoutComponent = layoutModel.getLayoutComponent();
        Container parent = layoutModel.getParent();
        gbc.anchor = layoutModel.getAnchor();
        gbc.fill = layoutModel.getFill();
        gbc.insets = new Insets(layoutModel.getInsets().getTop(), layoutModel.getInsets().getLeft(), layoutModel.getInsets().getBottom(), layoutModel.getInsets().getRight());
        gbc.gridx = layoutModel.getGridx();
        gbc.gridy = layoutModel.getGridy();
        gbc.gridwidth = layoutModel.getGridwidth();
        gbc.gridheight = layoutModel.getGridheight();
        gbc.weightx = layoutModel.getWeightx();
        gbc.weighty = layoutModel.getWeighty();
        gbc.ipadx = layoutModel.getIpadx();
        gbc.ipady = layoutModel.getIpady();
        layoutModel.getGridBagLayout().setConstraints(layoutComponent, gbc);
        parent.add(layoutComponent);
        if (ObjectExtensions.isNotDefaultValue((Object)layoutModel.getVerticalStrut())) {
            parent.add(Box.createVerticalStrut(layoutModel.getVerticalStrut()), gbc);
        }
        if (ObjectExtensions.isNotDefaultValue((Object)layoutModel.getHorizontalStrut())) {
            parent.add(Box.createHorizontalStrut(layoutModel.getHorizontalStrut()), gbc);
        }
    }

    public static void addComponent(GridBagLayout gbl, GridBagConstraints gbc, int gridx, int gridy, Component component, Container panelToAdd) {
        gbc.anchor = 10;
        gbc.fill = 1;
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.gridx = gridx;
        gbc.gridy = gridy;
        gbl.setConstraints(component, gbc);
        panelToAdd.add(component);
    }

    public static void addComponent(GridBagLayout gbl, GridBagConstraints gbc, int anchor, int fill, Insets insets, int gridx, int gridy, int gridwidth, int gridheight, double weightx, double weighty, Component addComponentToPanel, Container panelToAdd) {
        gbc.anchor = anchor;
        gbc.fill = fill;
        gbc.insets = insets;
        gbc.gridx = gridx;
        gbc.gridy = gridy;
        gbc.gridwidth = gridwidth;
        gbc.gridheight = gridheight;
        gbc.weightx = weightx;
        gbc.weighty = weighty;
        gbl.setConstraints(addComponentToPanel, gbc);
        panelToAdd.add(addComponentToPanel);
    }

    public static void addComponent(GridBagLayout gbl, GridBagConstraints gbc, int anchor, int fill, Insets insets, int gridx, int gridy, int gridwidth, int gridheight, double weightx, double weighty, int ipadx, int ipady, Component addComponentToPanel, Container panelToAdd) {
        gbc.anchor = anchor;
        gbc.fill = fill;
        gbc.insets = insets;
        gbc.gridx = gridx;
        gbc.gridy = gridy;
        gbc.gridwidth = gridwidth;
        gbc.gridheight = gridheight;
        gbc.weightx = weightx;
        gbc.weighty = weighty;
        gbc.ipadx = ipadx;
        gbc.ipady = ipady;
        gbl.setConstraints(addComponentToPanel, gbc);
        panelToAdd.add(addComponentToPanel);
    }

    public static void addComponentWithHorizontalStrutInBox(GridBagLayout gbl, GridBagConstraints gbc, int anchor, int fill, Insets insets, int gridx, int gridy, int gridwidth, int gridheight, double weightx, double weighty, int horizontalStrut, Component addComponentToPanel, Container panelToAdd) {
        gbc.anchor = anchor;
        gbc.fill = fill;
        gbc.insets = insets;
        gbc.gridx = gridx;
        gbc.gridy = gridy;
        gbc.gridwidth = gridwidth;
        gbc.gridheight = gridheight;
        gbc.weightx = weightx;
        gbc.weighty = weighty;
        gbl.setConstraints(addComponentToPanel, gbc);
        panelToAdd.add(addComponentToPanel);
        panelToAdd.add(Box.createHorizontalStrut(horizontalStrut), gbc);
    }

    public static void addComponentWithVerticalStrutInBox(GridBagLayout gbl, GridBagConstraints gbc, int anchor, int fill, Insets insets, int gridx, int gridy, int gridwidth, int gridheight, double weightx, double weighty, int verticalStrut, Component addComponentToPanel, Container panelToAdd) {
        gbc.anchor = anchor;
        gbc.fill = fill;
        gbc.insets = insets;
        gbc.gridx = gridx;
        gbc.gridy = gridy;
        gbc.gridwidth = gridwidth;
        gbc.gridheight = gridheight;
        gbc.weightx = weightx;
        gbc.weighty = weighty;
        gbl.setConstraints(addComponentToPanel, gbc);
        panelToAdd.add(addComponentToPanel);
        panelToAdd.add(Box.createVerticalStrut(verticalStrut), gbc);
    }
}

