/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.layout;

import de.alpharogroup.layout.InsetsModel;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.beans.ConstructorProperties;
import java.io.Serializable;

public class GridBagLayoutModel
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final GridBagLayout gridBagLayout;
    private final GridBagConstraints gridBagConstraints;
    private final int anchor;
    private final int fill;
    private final InsetsModel insets;
    private final int gridx;
    private final int gridy;
    private final int gridwidth;
    private final int gridheight;
    private final double weightx;
    private final double weighty;
    private final int ipadx;
    private final int ipady;
    private final int horizontalStrut;
    private final int verticalStrut;
    private final Component layoutComponent;
    private final Container parent;

    @ConstructorProperties(value={"gridBagLayout", "gridBagConstraints", "anchor", "fill", "insets", "gridx", "gridy", "gridwidth", "gridheight", "weightx", "weighty", "ipadx", "ipady", "horizontalStrut", "verticalStrut", "layoutComponent", "parent"})
    GridBagLayoutModel(GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, int anchor, int fill, InsetsModel insets, int gridx, int gridy, int gridwidth, int gridheight, double weightx, double weighty, int ipadx, int ipady, int horizontalStrut, int verticalStrut, Component layoutComponent, Container parent) {
        this.gridBagLayout = gridBagLayout;
        this.gridBagConstraints = gridBagConstraints;
        this.anchor = anchor;
        this.fill = fill;
        this.insets = insets;
        this.gridx = gridx;
        this.gridy = gridy;
        this.gridwidth = gridwidth;
        this.gridheight = gridheight;
        this.weightx = weightx;
        this.weighty = weighty;
        this.ipadx = ipadx;
        this.ipady = ipady;
        this.horizontalStrut = horizontalStrut;
        this.verticalStrut = verticalStrut;
        this.layoutComponent = layoutComponent;
        this.parent = parent;
    }

    public static GridBagLayoutModelBuilder builder() {
        return new GridBagLayoutModelBuilder();
    }

    public GridBagLayoutModelBuilder toBuilder() {
        return new GridBagLayoutModelBuilder().gridBagLayout(this.gridBagLayout).gridBagConstraints(this.gridBagConstraints).anchor(this.anchor).fill(this.fill).insets(this.insets).gridx(this.gridx).gridy(this.gridy).gridwidth(this.gridwidth).gridheight(this.gridheight).weightx(this.weightx).weighty(this.weighty).ipadx(this.ipadx).ipady(this.ipady).horizontalStrut(this.horizontalStrut).verticalStrut(this.verticalStrut).layoutComponent(this.layoutComponent).parent(this.parent);
    }

    public GridBagLayout getGridBagLayout() {
        return this.gridBagLayout;
    }

    public GridBagConstraints getGridBagConstraints() {
        return this.gridBagConstraints;
    }

    public int getAnchor() {
        return this.anchor;
    }

    public int getFill() {
        return this.fill;
    }

    public InsetsModel getInsets() {
        return this.insets;
    }

    public int getGridx() {
        return this.gridx;
    }

    public int getGridy() {
        return this.gridy;
    }

    public int getGridwidth() {
        return this.gridwidth;
    }

    public int getGridheight() {
        return this.gridheight;
    }

    public double getWeightx() {
        return this.weightx;
    }

    public double getWeighty() {
        return this.weighty;
    }

    public int getIpadx() {
        return this.ipadx;
    }

    public int getIpady() {
        return this.ipady;
    }

    public int getHorizontalStrut() {
        return this.horizontalStrut;
    }

    public int getVerticalStrut() {
        return this.verticalStrut;
    }

    public Component getLayoutComponent() {
        return this.layoutComponent;
    }

    public Container getParent() {
        return this.parent;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GridBagLayoutModel)) {
            return false;
        }
        GridBagLayoutModel other = (GridBagLayoutModel)o;
        if (!other.canEqual(this)) {
            return false;
        }
        GridBagLayout this$gridBagLayout = this.getGridBagLayout();
        GridBagLayout other$gridBagLayout = other.getGridBagLayout();
        if (this$gridBagLayout == null ? other$gridBagLayout != null : !this$gridBagLayout.equals(other$gridBagLayout)) {
            return false;
        }
        GridBagConstraints this$gridBagConstraints = this.getGridBagConstraints();
        GridBagConstraints other$gridBagConstraints = other.getGridBagConstraints();
        if (this$gridBagConstraints == null ? other$gridBagConstraints != null : !this$gridBagConstraints.equals(other$gridBagConstraints)) {
            return false;
        }
        if (this.getAnchor() != other.getAnchor()) {
            return false;
        }
        if (this.getFill() != other.getFill()) {
            return false;
        }
        InsetsModel this$insets = this.getInsets();
        InsetsModel other$insets = other.getInsets();
        if (this$insets == null ? other$insets != null : !((Object)this$insets).equals(other$insets)) {
            return false;
        }
        if (this.getGridx() != other.getGridx()) {
            return false;
        }
        if (this.getGridy() != other.getGridy()) {
            return false;
        }
        if (this.getGridwidth() != other.getGridwidth()) {
            return false;
        }
        if (this.getGridheight() != other.getGridheight()) {
            return false;
        }
        if (Double.compare(this.getWeightx(), other.getWeightx()) != 0) {
            return false;
        }
        if (Double.compare(this.getWeighty(), other.getWeighty()) != 0) {
            return false;
        }
        if (this.getIpadx() != other.getIpadx()) {
            return false;
        }
        if (this.getIpady() != other.getIpady()) {
            return false;
        }
        if (this.getHorizontalStrut() != other.getHorizontalStrut()) {
            return false;
        }
        if (this.getVerticalStrut() != other.getVerticalStrut()) {
            return false;
        }
        Component this$layoutComponent = this.getLayoutComponent();
        Component other$layoutComponent = other.getLayoutComponent();
        if (this$layoutComponent == null ? other$layoutComponent != null : !this$layoutComponent.equals(other$layoutComponent)) {
            return false;
        }
        Container this$parent = this.getParent();
        Container other$parent = other.getParent();
        return !(this$parent == null ? other$parent != null : !this$parent.equals(other$parent));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GridBagLayoutModel;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        GridBagLayout $gridBagLayout = this.getGridBagLayout();
        result = result * 59 + ($gridBagLayout == null ? 43 : $gridBagLayout.hashCode());
        GridBagConstraints $gridBagConstraints = this.getGridBagConstraints();
        result = result * 59 + ($gridBagConstraints == null ? 43 : $gridBagConstraints.hashCode());
        result = result * 59 + this.getAnchor();
        result = result * 59 + this.getFill();
        InsetsModel $insets = this.getInsets();
        result = result * 59 + ($insets == null ? 43 : ((Object)$insets).hashCode());
        result = result * 59 + this.getGridx();
        result = result * 59 + this.getGridy();
        result = result * 59 + this.getGridwidth();
        result = result * 59 + this.getGridheight();
        long $weightx = Double.doubleToLongBits(this.getWeightx());
        result = result * 59 + (int)($weightx >>> 32 ^ $weightx);
        long $weighty = Double.doubleToLongBits(this.getWeighty());
        result = result * 59 + (int)($weighty >>> 32 ^ $weighty);
        result = result * 59 + this.getIpadx();
        result = result * 59 + this.getIpady();
        result = result * 59 + this.getHorizontalStrut();
        result = result * 59 + this.getVerticalStrut();
        Component $layoutComponent = this.getLayoutComponent();
        result = result * 59 + ($layoutComponent == null ? 43 : $layoutComponent.hashCode());
        Container $parent = this.getParent();
        result = result * 59 + ($parent == null ? 43 : $parent.hashCode());
        return result;
    }

    public String toString() {
        return "GridBagLayoutModel(gridBagLayout=" + this.getGridBagLayout() + ", gridBagConstraints=" + this.getGridBagConstraints() + ", anchor=" + this.getAnchor() + ", fill=" + this.getFill() + ", insets=" + this.getInsets() + ", gridx=" + this.getGridx() + ", gridy=" + this.getGridy() + ", gridwidth=" + this.getGridwidth() + ", gridheight=" + this.getGridheight() + ", weightx=" + this.getWeightx() + ", weighty=" + this.getWeighty() + ", ipadx=" + this.getIpadx() + ", ipady=" + this.getIpady() + ", horizontalStrut=" + this.getHorizontalStrut() + ", verticalStrut=" + this.getVerticalStrut() + ", layoutComponent=" + this.getLayoutComponent() + ", parent=" + this.getParent() + ")";
    }

    public static class GridBagLayoutModelBuilder {
        private GridBagLayout gridBagLayout;
        private GridBagConstraints gridBagConstraints;
        private int anchor;
        private int fill;
        private InsetsModel insets;
        private int gridx;
        private int gridy;
        private int gridwidth;
        private int gridheight;
        private double weightx;
        private double weighty;
        private int ipadx;
        private int ipady;
        private int horizontalStrut;
        private int verticalStrut;
        private Component layoutComponent;
        private Container parent;

        GridBagLayoutModelBuilder() {
        }

        public GridBagLayoutModelBuilder gridBagLayout(GridBagLayout gridBagLayout) {
            this.gridBagLayout = gridBagLayout;
            return this;
        }

        public GridBagLayoutModelBuilder gridBagConstraints(GridBagConstraints gridBagConstraints) {
            this.gridBagConstraints = gridBagConstraints;
            return this;
        }

        public GridBagLayoutModelBuilder anchor(int anchor) {
            this.anchor = anchor;
            return this;
        }

        public GridBagLayoutModelBuilder fill(int fill) {
            this.fill = fill;
            return this;
        }

        public GridBagLayoutModelBuilder insets(InsetsModel insets) {
            this.insets = insets;
            return this;
        }

        public GridBagLayoutModelBuilder gridx(int gridx) {
            this.gridx = gridx;
            return this;
        }

        public GridBagLayoutModelBuilder gridy(int gridy) {
            this.gridy = gridy;
            return this;
        }

        public GridBagLayoutModelBuilder gridwidth(int gridwidth) {
            this.gridwidth = gridwidth;
            return this;
        }

        public GridBagLayoutModelBuilder gridheight(int gridheight) {
            this.gridheight = gridheight;
            return this;
        }

        public GridBagLayoutModelBuilder weightx(double weightx) {
            this.weightx = weightx;
            return this;
        }

        public GridBagLayoutModelBuilder weighty(double weighty) {
            this.weighty = weighty;
            return this;
        }

        public GridBagLayoutModelBuilder ipadx(int ipadx) {
            this.ipadx = ipadx;
            return this;
        }

        public GridBagLayoutModelBuilder ipady(int ipady) {
            this.ipady = ipady;
            return this;
        }

        public GridBagLayoutModelBuilder horizontalStrut(int horizontalStrut) {
            this.horizontalStrut = horizontalStrut;
            return this;
        }

        public GridBagLayoutModelBuilder verticalStrut(int verticalStrut) {
            this.verticalStrut = verticalStrut;
            return this;
        }

        public GridBagLayoutModelBuilder layoutComponent(Component layoutComponent) {
            this.layoutComponent = layoutComponent;
            return this;
        }

        public GridBagLayoutModelBuilder parent(Container parent) {
            this.parent = parent;
            return this;
        }

        public GridBagLayoutModel build() {
            return new GridBagLayoutModel(this.gridBagLayout, this.gridBagConstraints, this.anchor, this.fill, this.insets, this.gridx, this.gridy, this.gridwidth, this.gridheight, this.weightx, this.weighty, this.ipadx, this.ipady, this.horizontalStrut, this.verticalStrut, this.layoutComponent, this.parent);
        }

        public String toString() {
            return "GridBagLayoutModel.GridBagLayoutModelBuilder(gridBagLayout=" + this.gridBagLayout + ", gridBagConstraints=" + this.gridBagConstraints + ", anchor=" + this.anchor + ", fill=" + this.fill + ", insets=" + this.insets + ", gridx=" + this.gridx + ", gridy=" + this.gridy + ", gridwidth=" + this.gridwidth + ", gridheight=" + this.gridheight + ", weightx=" + this.weightx + ", weighty=" + this.weighty + ", ipadx=" + this.ipadx + ", ipady=" + this.ipady + ", horizontalStrut=" + this.horizontalStrut + ", verticalStrut=" + this.verticalStrut + ", layoutComponent=" + this.layoutComponent + ", parent=" + this.parent + ")";
        }
    }
}

