/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.behaviors;

import javax.swing.ButtonModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

public class EnableButtonBehavior
implements DocumentListener {
    private final ButtonModel buttonModel;
    private final Document document;
    private boolean enabled;

    public EnableButtonBehavior(ButtonModel buttonModel, Document document, boolean enabled) {
        this.buttonModel = buttonModel;
        this.document = document;
        this.enabled = enabled;
        this.document.addDocumentListener(this);
        if (!this.enabled) {
            this.onChange();
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.onChange();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.onChange();
    }

    protected void onChange() {
        this.enabled = false;
        if (this.document.getLength() > 0) {
            this.enabled = true;
        }
        this.buttonModel.setEnabled(this.enabled);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.onChange();
    }

    public static EnableButtonBehaviorBuilder builder() {
        return new EnableButtonBehaviorBuilder();
    }

    public EnableButtonBehaviorBuilder toBuilder() {
        return new EnableButtonBehaviorBuilder().buttonModel(this.buttonModel).document(this.document).enabled(this.enabled);
    }

    public ButtonModel getButtonModel() {
        return this.buttonModel;
    }

    public Document getDocument() {
        return this.document;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EnableButtonBehavior)) {
            return false;
        }
        EnableButtonBehavior other = (EnableButtonBehavior)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ButtonModel this$buttonModel = this.getButtonModel();
        ButtonModel other$buttonModel = other.getButtonModel();
        if (this$buttonModel == null ? other$buttonModel != null : !this$buttonModel.equals(other$buttonModel)) {
            return false;
        }
        Document this$document = this.getDocument();
        Document other$document = other.getDocument();
        if (this$document == null ? other$document != null : !this$document.equals(other$document)) {
            return false;
        }
        return this.isEnabled() == other.isEnabled();
    }

    protected boolean canEqual(Object other) {
        return other instanceof EnableButtonBehavior;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ButtonModel $buttonModel = this.getButtonModel();
        result = result * 59 + ($buttonModel == null ? 43 : $buttonModel.hashCode());
        Document $document = this.getDocument();
        result = result * 59 + ($document == null ? 43 : $document.hashCode());
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "EnableButtonBehavior(buttonModel=" + this.getButtonModel() + ", document=" + this.getDocument() + ", enabled=" + this.isEnabled() + ")";
    }

    public static class EnableButtonBehaviorBuilder {
        private ButtonModel buttonModel;
        private Document document;
        private boolean enabled;

        EnableButtonBehaviorBuilder() {
        }

        public EnableButtonBehaviorBuilder buttonModel(ButtonModel buttonModel) {
            this.buttonModel = buttonModel;
            return this;
        }

        public EnableButtonBehaviorBuilder document(Document document) {
            this.document = document;
            return this;
        }

        public EnableButtonBehaviorBuilder enabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public EnableButtonBehavior build() {
            return new EnableButtonBehavior(this.buttonModel, this.document, this.enabled);
        }

        public String toString() {
            return "EnableButtonBehavior.EnableButtonBehaviorBuilder(buttonModel=" + this.buttonModel + ", document=" + this.document + ", enabled=" + this.enabled + ")";
        }
    }
}

