/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.layout;

import java.awt.Component;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.util.Optional;
import javax.swing.JFrame;

public class GraphicsDeviceExtensions {
    public static GraphicsDevice[] getAvailableScreens() {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] graphicsDevices = graphicsEnvironment.getScreenDevices();
        return graphicsDevices;
    }

    public static Optional<GraphicsDevice> getGraphicsDevice(int index) {
        if (GraphicsDeviceExtensions.isScreenAvailableToShow(index)) {
            GraphicsDevice[] graphicsDevices = GraphicsDeviceExtensions.getAvailableScreens();
            return Optional.of(graphicsDevices[index]);
        }
        return Optional.empty();
    }

    public static GraphicsDevice getGraphicsDeviceIsShowingOn(Component component) {
        GraphicsDevice graphicsDevice = component.getGraphicsConfiguration().getDevice();
        return graphicsDevice;
    }

    public static int getGraphicsDeviceIndexIsShowingOn(Component component) {
        GraphicsDevice graphicsDevice = GraphicsDeviceExtensions.getGraphicsDeviceIsShowingOn(component);
        GraphicsDevice[] graphicsDevices = GraphicsDeviceExtensions.getAvailableScreens();
        for (int i = 0; i < graphicsDevices.length; ++i) {
            if (!graphicsDevices[i].equals(graphicsDevice)) continue;
            return i;
        }
        return 0;
    }

    public static boolean isScreenAvailableToShow(int screen) {
        GraphicsDevice[] graphicsDevices = GraphicsDeviceExtensions.getAvailableScreens();
        boolean screenAvailableToShow = false;
        if (screen > -1 && screen < graphicsDevices.length || graphicsDevices.length > 0) {
            screenAvailableToShow = true;
        }
        return screenAvailableToShow;
    }

    public static void showOnScreen(int screen, JFrame frame) {
        if (GraphicsDeviceExtensions.isScreenAvailableToShow(screen)) {
            GraphicsDevice[] graphicsDevices = GraphicsDeviceExtensions.getAvailableScreens();
            graphicsDevices[screen].setFullScreenWindow(frame);
        }
    }
}

