/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.collections.map;

import de.alpharogroup.collections.list.ListFactory;
import de.alpharogroup.collections.map.InsertionOrderMap;
import de.alpharogroup.collections.pairs.KeyValuePair;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import lombok.NonNull;
import org.apache.commons.collections4.Factory;
import org.apache.commons.collections4.functors.InstantiateFactory;
import org.apache.commons.collections4.map.LazyMap;

public final class MapFactory {
    public static <K> Map<K, Integer> newCounterMap(@NonNull Collection<K> elements) {
        if (elements == null) {
            throw new NullPointerException("elements is marked non-null but is null");
        }
        Map<K, Integer> elementsCount = MapFactory.newHashMap();
        for (K element : elements) {
            if (elementsCount.containsKey(element)) {
                elementsCount.merge(element, 1, Integer::sum);
                continue;
            }
            elementsCount.put(element, 0);
        }
        return elementsCount;
    }

    public static <K, V> Map<K, V> newInsertionOrderMap() {
        return new InsertionOrderMap();
    }

    public static <K, V> Map<K, V> newInsertionOrderMap(int initialCapacity) {
        return new InsertionOrderMap(initialCapacity);
    }

    public static <K, V> Map<K, V> newInsertionOrderMap(@NonNull Map<K, V> map) {
        if (map == null) {
            throw new NullPointerException("map is marked non-null but is null");
        }
        return new InsertionOrderMap<K, V>(map);
    }

    public static <K, V> Map<K, V> newInsertionOrderMap(@NonNull Collection<KeyValuePair<K, V>> keyValuePairs) {
        if (keyValuePairs == null) {
            throw new NullPointerException("keyValuePairs is marked non-null but is null");
        }
        return MapFactory.newInsertionOrderMap(KeyValuePair.toMap(keyValuePairs));
    }

    @SafeVarargs
    public static <K, V> Map<K, V> newInsertionOrderMap(KeyValuePair<K, V> ... keyValuePairs) {
        if (keyValuePairs == null) {
            throw new NullPointerException("keyValuePairs is marked non-null but is null");
        }
        return MapFactory.newInsertionOrderMap(ListFactory.newArrayList(keyValuePairs));
    }

    public static Map<Integer, Map<String, String>> newAssosiativeArrayMap() {
        return MapFactory.newLazyMap();
    }

    public static <K, V> ConcurrentHashMap<K, V> newConcurrentHashMap() {
        return new ConcurrentHashMap();
    }

    public static <K, V> ConcurrentHashMap<K, V> newConcurrentHashMap(@NonNull Map<K, V> map) {
        if (map == null) {
            throw new NullPointerException("map is marked non-null but is null");
        }
        return new ConcurrentHashMap<K, V>(map);
    }

    public static <K, V> ConcurrentHashMap<K, V> newConcurrentHashMap(int initialCapacity) {
        return new ConcurrentHashMap(initialCapacity);
    }

    public static <K, V> Map<K, V> newHashMap(int initialCapacity) {
        return new HashMap(initialCapacity);
    }

    public static <K, V> Map<K, V> newHashMap() {
        return new HashMap();
    }

    public static <K, V> Map<K, V> newHashMap(@NonNull Map<K, V> map) {
        if (map == null) {
            throw new NullPointerException("map is marked non-null but is null");
        }
        return new HashMap<K, V>(map);
    }

    public static <K, V> Map<K, V> newHashMap(@NonNull Collection<KeyValuePair<K, V>> keyValuePairs) {
        if (keyValuePairs == null) {
            throw new NullPointerException("keyValuePairs is marked non-null but is null");
        }
        return MapFactory.newHashMap(KeyValuePair.toMap(keyValuePairs));
    }

    @SafeVarargs
    public static <K, V> Map<K, V> newHashMap(KeyValuePair<K, V> ... keyValuePairs) {
        if (keyValuePairs == null) {
            throw new NullPointerException("keyValuePairs is marked non-null but is null");
        }
        return MapFactory.newHashMap(ListFactory.newArrayList(keyValuePairs));
    }

    public static <K, V> Map<K, V> newLinkedHashMap() {
        return new LinkedHashMap();
    }

    public static <K, V> Map<K, V> newLinkedHashMap(@NonNull Map<K, V> map) {
        if (map == null) {
            throw new NullPointerException("map is marked non-null but is null");
        }
        return new LinkedHashMap<K, V>(map);
    }

    public static <K, V> Map<K, V> newLinkedHashMap(@NonNull Collection<KeyValuePair<K, V>> keyValuePairs) {
        if (keyValuePairs == null) {
            throw new NullPointerException("keyValuePairs is marked non-null but is null");
        }
        return MapFactory.newLinkedHashMap(KeyValuePair.toMap(keyValuePairs));
    }

    @SafeVarargs
    public static <K, V> Map<K, V> newLinkedHashMap(KeyValuePair<K, V> ... keyValuePairs) {
        if (keyValuePairs == null) {
            throw new NullPointerException("keyValuePairs is marked non-null but is null");
        }
        return MapFactory.newLinkedHashMap(ListFactory.newArrayList(keyValuePairs));
    }

    public static <K, V> Map<K, V> newLinkedHashMap(int initialCapacity) {
        return new LinkedHashMap(initialCapacity);
    }

    public static <K, V> Map<K, V> newLazyMap() {
        return MapFactory.newLazyHashMap();
    }

    public static <K, V> Map<K, V> newLazyHashMap() {
        return MapFactory.newLazyHashMap(new HashMap());
    }

    public static <K, V> Map<K, V> newLazyHashMap(HashMap<K, V> map) {
        return LazyMap.lazyMap(map, (Factory)new InstantiateFactory(HashMap.class));
    }

    public static <K, V> Map<K, V> newLazyTreeMap() {
        return MapFactory.newLazyTreeMap(new TreeMap());
    }

    public static <K, V> Map<K, V> newLazyTreeMap(@NonNull TreeMap<K, V> map) {
        if (map == null) {
            throw new NullPointerException("map is marked non-null but is null");
        }
        return LazyMap.lazyMap(map, (Factory)new InstantiateFactory(TreeMap.class));
    }

    public static <K, V> Map<K, V> newLazyTreeMap(@NonNull Comparator<? super K> comparator) {
        if (comparator == null) {
            throw new NullPointerException("comparator is marked non-null but is null");
        }
        return LazyMap.lazyMap(new TreeMap(comparator), (Factory)new InstantiateFactory(TreeMap.class));
    }

    public static <K, V> Map<K, V> newTreeMap() {
        return new TreeMap();
    }

    public static <K, V> Map<K, V> newTreeMap(@NonNull Map<K, V> map) {
        if (map == null) {
            throw new NullPointerException("map is marked non-null but is null");
        }
        return new TreeMap<K, V>(map);
    }

    public static <K, V> Map<K, V> newTreeMap(@NonNull Comparator<? super K> comparator) {
        if (comparator == null) {
            throw new NullPointerException("comparator is marked non-null but is null");
        }
        return new TreeMap(comparator);
    }

    public static <K, V> Map<K, V> newTreeMap(@NonNull Comparator<? super K> comparator, @NonNull Collection<KeyValuePair<K, V>> keyValuePairs) {
        if (comparator == null) {
            throw new NullPointerException("comparator is marked non-null but is null");
        }
        if (keyValuePairs == null) {
            throw new NullPointerException("keyValuePairs is marked non-null but is null");
        }
        TreeMap<K, V> treeMap = new TreeMap<K, V>(comparator);
        treeMap.putAll(MapFactory.newTreeMap(keyValuePairs));
        return treeMap;
    }

    @SafeVarargs
    public static <K, V> Map<K, V> newTreeMap(@NonNull Comparator<? super K> comparator, KeyValuePair<K, V> ... keyValuePairs) {
        if (comparator == null) {
            throw new NullPointerException("comparator is marked non-null but is null");
        }
        if (keyValuePairs == null) {
            throw new NullPointerException("keyValuePairs is marked non-null but is null");
        }
        TreeMap<K, V> treeMap = new TreeMap<K, V>(comparator);
        treeMap.putAll(MapFactory.newTreeMap(keyValuePairs));
        return treeMap;
    }

    public static <K, V> Map<K, V> newTreeMap(@NonNull Collection<KeyValuePair<K, V>> keyValuePairs) {
        if (keyValuePairs == null) {
            throw new NullPointerException("keyValuePairs is marked non-null but is null");
        }
        return MapFactory.newTreeMap(KeyValuePair.toMap(keyValuePairs));
    }

    @SafeVarargs
    public static <K, V> Map<K, V> newTreeMap(KeyValuePair<K, V> ... keyValuePairs) {
        if (keyValuePairs == null) {
            throw new NullPointerException("keyValuePairs is marked non-null but is null");
        }
        return MapFactory.newTreeMap(ListFactory.newArrayList(keyValuePairs));
    }

    private MapFactory() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

