/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.collections.map;

import de.alpharogroup.collections.map.InsertionOrderMap;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections4.Factory;
import org.apache.commons.collections4.functors.InstantiateFactory;
import org.apache.commons.collections4.map.LazyMap;

public final class MapFactory {
    public static <K> Map<K, Integer> newCounterMap(Collection<K> elements) {
        Map<K, Integer> elementsCount = MapFactory.newHashMap();
        for (K element : elements) {
            if (elementsCount.containsKey(element)) {
                elementsCount.merge(element, 1, Integer::sum);
                continue;
            }
            elementsCount.put(element, 0);
        }
        return elementsCount;
    }

    public static <K, V> Map<K, V> newInsertionOrderMap() {
        return new InsertionOrderMap();
    }

    public static <K, V> Map<K, V> newInsertionOrderMap(int initialCapacity) {
        return new InsertionOrderMap(initialCapacity);
    }

    public static <K, V> Map<K, V> newInsertionOrderMap(Map<K, V> map) {
        return new InsertionOrderMap<K, V>(map);
    }

    public static Map<Integer, Map<String, String>> newAssosiativeArrayMap() {
        return MapFactory.newLazyMap();
    }

    public static <K, V> ConcurrentHashMap<K, V> newConcurrentHashMap() {
        return new ConcurrentHashMap();
    }

    public static <K, V> ConcurrentHashMap<K, V> newConcurrentHashMap(Map<K, V> map) {
        return new ConcurrentHashMap<K, V>(map);
    }

    public static <K, V> ConcurrentHashMap<K, V> newConcurrentHashMap(int initialCapacity) {
        return new ConcurrentHashMap(initialCapacity);
    }

    public static <K, V> Map<K, V> newHashMap() {
        return new HashMap();
    }

    public static <K, V> Map<K, V> newHashMap(Map<K, V> map) {
        return new HashMap<K, V>(map);
    }

    public static <K, V> Map<K, V> newLinkedHashMap() {
        return new LinkedHashMap();
    }

    public static <K, V> Map<K, V> newLinkedHashMap(Map<K, V> map) {
        return new LinkedHashMap<K, V>(map);
    }

    public static <K, V> Map<K, V> newLinkedHashMap(int initialCapacity) {
        return new LinkedHashMap(initialCapacity);
    }

    public static <K, V> Map<K, V> newHashMap(int initialCapacity) {
        return new HashMap(initialCapacity);
    }

    public static <K, V> Map<K, V> newLazyMap() {
        return MapFactory.newLazyHashMap();
    }

    public static <K, V> Map<K, V> newLazyHashMap() {
        return MapFactory.newLazyHashMap(new HashMap());
    }

    public static <K, V> Map<K, V> newLazyHashMap(HashMap<K, V> map) {
        return LazyMap.lazyMap(map, (Factory)new InstantiateFactory(HashMap.class));
    }

    public static <K, V> Map<K, V> newLazyTreeMap() {
        return MapFactory.newLazyTreeMap(new TreeMap());
    }

    public static <K, V> Map<K, V> newLazyTreeMap(TreeMap<K, V> map) {
        return LazyMap.lazyMap(map, (Factory)new InstantiateFactory(TreeMap.class));
    }

    public static <K, V> Map<K, V> newLazyTreeMap(Comparator<? super K> comparator) {
        return LazyMap.lazyMap(new TreeMap(comparator), (Factory)new InstantiateFactory(TreeMap.class));
    }

    public static <K, V> Map<K, V> newTreeMap() {
        return new TreeMap();
    }

    public static <K, V> Map<K, V> newTreeMap(Map<K, V> map) {
        return new TreeMap<K, V>(map);
    }

    public static <K, V> Map<K, V> newTreeMap(Comparator<? super K> comparator) {
        return new TreeMap(comparator);
    }

    private MapFactory() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

