/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.collections.properties;

import de.alpharogroup.collections.list.VectorExtensions;
import de.alpharogroup.comparators.NullCheckComparator;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;

public class SortedProperties
extends Properties {
    private static final long serialVersionUID = 1L;
    private Comparator<Object> comparator;

    public static SortedProperties of() {
        return new SortedProperties();
    }

    public static SortedProperties of(Properties defaults) {
        return new SortedProperties(defaults);
    }

    public static SortedProperties of(Properties defaults, final Comparator<Object> comparator) {
        return new SortedProperties(defaults){
            private static final long serialVersionUID = 1L;

            @Override
            protected Comparator<Object> newComparator() {
                return NullCheckComparator.of((Comparator)comparator, (boolean)false);
            }
        };
    }

    public SortedProperties() {
        this(new Properties());
    }

    public SortedProperties(Properties defaults) {
        super(defaults);
    }

    public Comparator<Object> getComparator() {
        if (this.comparator == null) {
            this.comparator = this.newComparator();
        }
        return this.comparator;
    }

    @Override
    public synchronized Enumeration<Object> keys() {
        Vector<Object> keys = VectorExtensions.toVector(super.keys());
        Collections.sort(keys, this.getComparator());
        return keys.elements();
    }

    @Override
    public Set<Object> keySet() {
        TreeSet<Object> set = new TreeSet<Object>(this.getComparator());
        set.addAll(super.keySet());
        return set;
    }

    protected Comparator<Object> newComparator() {
        return NullCheckComparator.of((o1, o2) -> o1.toString().compareTo(o2.toString()), (boolean)false);
    }

    @Override
    public Enumeration<?> propertyNames() {
        TreeSet<Object> set = new TreeSet<Object>(this.getComparator());
        set.addAll(super.keySet());
        return Collections.enumeration(set);
    }
}

