/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.collections.map;

import de.alpharogroup.collections.list.ListFactory;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.NonNull;

public final class MapExtensions {
    public static <K, V extends Comparable<? super V>> List<Map.Entry<K, V>> sortByValueAsList(@NonNull Map<K, V> map, boolean reversed) {
        if (map == null) {
            throw new NullPointerException("map is marked non-null but is null");
        }
        return MapExtensions.sortByValueAsList(map, reversed ? Comparator.reverseOrder() : Comparator.naturalOrder());
    }

    public static <K, V extends Comparable<? super V>> List<Map.Entry<K, V>> sortByValueAsList(@NonNull Map<K, V> map, @NonNull Comparator<? super V> comparator) {
        if (map == null) {
            throw new NullPointerException("map is marked non-null but is null");
        }
        if (comparator == null) {
            throw new NullPointerException("comparator is marked non-null but is null");
        }
        return map.entrySet().stream().sorted(Map.Entry.comparingByValue(comparator)).collect(Collectors.toList());
    }

    public static <K, V extends Comparable<? super V>> Map<K, V> sortByValue(@NonNull Map<K, V> map, boolean reversed) {
        if (map == null) {
            throw new NullPointerException("map is marked non-null but is null");
        }
        return MapExtensions.sortByValue(map, reversed ? Comparator.reverseOrder() : Comparator.naturalOrder());
    }

    public static <K, V extends Comparable<? super V>> Map<K, V> sortByValue(@NonNull Map<K, V> map, @NonNull Comparator<? super V> comparator) {
        if (map == null) {
            throw new NullPointerException("map is marked non-null but is null");
        }
        if (comparator == null) {
            throw new NullPointerException("comparator is marked non-null but is null");
        }
        return map.entrySet().stream().sorted(Map.Entry.comparingByValue(comparator)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (k, v) -> k, LinkedHashMap::new));
    }

    public static <K, V> K getKeyFromValue(@NonNull Map<K, V> map, V value) {
        Map.Entry<K, V> entry;
        if (map == null) {
            throw new NullPointerException("map is marked non-null but is null");
        }
        K key = null;
        Iterator<Map.Entry<K, V>> iterator = map.entrySet().iterator();
        while (iterator.hasNext() && !map.get(key = (K)(entry = iterator.next()).getKey()).equals(value)) {
        }
        return key;
    }

    public static <K, V> Collection<K> getKeysFromValue(@NonNull Map<K, V> map, V value) {
        if (map == null) {
            throw new NullPointerException("map is marked non-null but is null");
        }
        List<Object> keys = ListFactory.newArrayList(new Object[0]);
        for (Map.Entry<K, V> entry : map.entrySet()) {
            V val = entry.getValue();
            if (!val.equals(value)) continue;
            K key = entry.getKey();
            keys.add(key);
        }
        return keys;
    }

    public static <T> Map<T, T> toGenericMap(@NonNull T[][] twoDimArray) {
        if (twoDimArray == null) {
            throw new NullPointerException("twoDimArray is marked non-null but is null");
        }
        LinkedHashMap<T, T> map = new LinkedHashMap<T, T>();
        for (T[] element : twoDimArray) {
            T key = element[0];
            T value = element[1];
            map.put(key, value);
        }
        return map;
    }

    public static Map<String, String> toMap(String[][] twoDimArray) {
        return MapExtensions.toGenericMap(twoDimArray);
    }

    private MapExtensions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

