/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.collections.list;

import de.alpharogroup.collections.CollectionExtensions;
import de.alpharogroup.collections.list.ListExtensions;
import java.util.List;
import java.util.Optional;
import lombok.NonNull;

public final class OptionalListExtensions {
    public static <T> Optional<T> getFirst(@NonNull List<T> list) {
        if (list == null) {
            throw new NullPointerException("list is marked non-null but is null");
        }
        if (CollectionExtensions.isNotEmpty(list)) {
            return Optional.of(list.get(0));
        }
        return Optional.empty();
    }

    public static <T> Optional<T> getLast(@NonNull List<T> list) {
        if (list == null) {
            throw new NullPointerException("list is marked non-null but is null");
        }
        if (CollectionExtensions.isNotEmpty(list)) {
            return Optional.of(list.get(list.size() - 1));
        }
        return Optional.empty();
    }

    public static <T> Optional<T> removeFirst(@NonNull List<T> list) {
        if (list == null) {
            throw new NullPointerException("list is marked non-null but is null");
        }
        if (!CollectionExtensions.isEmpty(list) && 0 < list.size()) {
            return Optional.of(list.remove(0));
        }
        return Optional.empty();
    }

    public static <T> Optional<T> removeLast(@NonNull List<T> list) {
        if (list == null) {
            throw new NullPointerException("list is marked non-null but is null");
        }
        if (!CollectionExtensions.isEmpty(list) && 0 < list.size()) {
            return Optional.of(list.remove(list.size() - 1));
        }
        return Optional.empty();
    }

    public static <T> Optional<T> getPrevious(@NonNull List<T> list, T element) {
        if (list == null) {
            throw new NullPointerException("list is marked non-null but is null");
        }
        int indexOfElement = list.indexOf(element);
        if (indexOfElement == -1 || indexOfElement == 0) {
            return Optional.empty();
        }
        int previousIndex = indexOfElement - 1;
        return Optional.of(list.get(previousIndex));
    }

    public static <T> Optional<T> getNext(@NonNull List<T> list, T element) {
        if (list == null) {
            throw new NullPointerException("list is marked non-null but is null");
        }
        if (ListExtensions.hasNext(list, element)) {
            int nextIndex = list.indexOf(element) + 1;
            return Optional.of(list.get(nextIndex));
        }
        return Optional.empty();
    }

    private OptionalListExtensions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

