/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.collections.list;

import de.alpharogroup.collections.CollectionExtensions;
import de.alpharogroup.collections.array.ArrayFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public final class ListFactory {
    @SafeVarargs
    public static <T> List<T> newArrayList(Collection<T> collection, T ... elements) {
        ArrayList<Object> list;
        if (CollectionExtensions.isNotEmpty(collection)) {
            list = new ArrayList<T>(collection);
            Collections.addAll(list, elements);
        } else {
            list = new ArrayList();
            Collections.addAll(list, elements);
        }
        return list;
    }

    @SafeVarargs
    public static <T> List<T> newArrayList(T ... elements) {
        return ListFactory.newArrayList(null, elements);
    }

    public static List<Integer> newRangeList(int start, int end) {
        return Arrays.asList(ArrayFactory.newRangeArray(start, end));
    }

    @SafeVarargs
    public static <T> List<T> newLinkedList(Collection<T> collection, T ... elements) {
        LinkedList<Object> list;
        if (CollectionExtensions.isNotEmpty(collection)) {
            list = new LinkedList<T>(collection);
            Collections.addAll(list, elements);
        } else {
            list = new LinkedList();
            Collections.addAll(list, elements);
        }
        return list;
    }

    @SafeVarargs
    public static <T> List<T> newLinkedList(T ... elements) {
        return ListFactory.newLinkedList(null, elements);
    }

    private ListFactory() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

