/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.collections.pairs;

import java.io.Serializable;

public class Pair<K, V>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private K leftContent;
    private V rightContent;

    public static <K, V> PairBuilder<K, V> builder() {
        return new PairBuilder();
    }

    public PairBuilder<K, V> toBuilder() {
        return new PairBuilder().leftContent(this.leftContent).rightContent(this.rightContent);
    }

    public K getLeftContent() {
        return this.leftContent;
    }

    public V getRightContent() {
        return this.rightContent;
    }

    public void setLeftContent(K leftContent) {
        this.leftContent = leftContent;
    }

    public void setRightContent(V rightContent) {
        this.rightContent = rightContent;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Pair)) {
            return false;
        }
        Pair other = (Pair)o;
        if (!other.canEqual(this)) {
            return false;
        }
        K this$leftContent = this.getLeftContent();
        K other$leftContent = other.getLeftContent();
        if (this$leftContent == null ? other$leftContent != null : !this$leftContent.equals(other$leftContent)) {
            return false;
        }
        V this$rightContent = this.getRightContent();
        V other$rightContent = other.getRightContent();
        return !(this$rightContent == null ? other$rightContent != null : !this$rightContent.equals(other$rightContent));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Pair;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        K $leftContent = this.getLeftContent();
        result = result * 59 + ($leftContent == null ? 43 : $leftContent.hashCode());
        V $rightContent = this.getRightContent();
        result = result * 59 + ($rightContent == null ? 43 : $rightContent.hashCode());
        return result;
    }

    public String toString() {
        return "Pair(leftContent=" + this.getLeftContent() + ", rightContent=" + this.getRightContent() + ")";
    }

    public Pair() {
    }

    public Pair(K leftContent, V rightContent) {
        this.leftContent = leftContent;
        this.rightContent = rightContent;
    }

    public static class PairBuilder<K, V> {
        private K leftContent;
        private V rightContent;

        PairBuilder() {
        }

        public PairBuilder<K, V> leftContent(K leftContent) {
            this.leftContent = leftContent;
            return this;
        }

        public PairBuilder<K, V> rightContent(V rightContent) {
            this.rightContent = rightContent;
            return this;
        }

        public Pair<K, V> build() {
            return new Pair<K, V>(this.leftContent, this.rightContent);
        }

        public String toString() {
            return "Pair.PairBuilder(leftContent=" + this.leftContent + ", rightContent=" + this.rightContent + ")";
        }
    }
}

