/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.collections.pairs;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class KeyValuesPair<K, V>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private K key;
    private Collection<V> values;

    public static <K, V> KeyValuesPairBuilder<K, V> builder() {
        return new KeyValuesPairBuilder();
    }

    public KeyValuesPairBuilder<K, V> toBuilder() {
        return new KeyValuesPairBuilder().key(this.key).values(this.values);
    }

    public K getKey() {
        return this.key;
    }

    public Collection<V> getValues() {
        return this.values;
    }

    public void setKey(K key) {
        this.key = key;
    }

    public void setValues(Collection<V> values) {
        this.values = values;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KeyValuesPair)) {
            return false;
        }
        KeyValuesPair other = (KeyValuesPair)o;
        K this$key = this.getKey();
        K other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        Collection<V> this$values = this.getValues();
        Collection<V> other$values = other.getValues();
        return !(this$values == null ? other$values != null : !((Object)this$values).equals(other$values));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        K $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        Collection<V> $values = this.getValues();
        result = result * 59 + ($values == null ? 43 : ((Object)$values).hashCode());
        return result;
    }

    public String toString() {
        return "KeyValuesPair(key=" + this.getKey() + ", values=" + this.getValues() + ")";
    }

    public KeyValuesPair() {
    }

    public KeyValuesPair(K key, Collection<V> values) {
        this.key = key;
        this.values = values;
    }

    public static class KeyValuesPairBuilder<K, V> {
        private K key;
        private ArrayList<V> values;

        KeyValuesPairBuilder() {
        }

        public KeyValuesPairBuilder<K, V> key(K key) {
            this.key = key;
            return this;
        }

        public KeyValuesPairBuilder<K, V> value(V value) {
            if (this.values == null) {
                this.values = new ArrayList();
            }
            this.values.add(value);
            return this;
        }

        public KeyValuesPairBuilder<K, V> values(Collection<? extends V> values) {
            if (this.values == null) {
                this.values = new ArrayList();
            }
            this.values.addAll(values);
            return this;
        }

        public KeyValuesPairBuilder<K, V> clearValues() {
            if (this.values != null) {
                this.values.clear();
            }
            return this;
        }

        public KeyValuesPair<K, V> build() {
            List<Object> values;
            switch (this.values == null ? 0 : this.values.size()) {
                case 0: {
                    values = Collections.emptyList();
                    break;
                }
                case 1: {
                    values = Collections.singletonList(this.values.get(0));
                    break;
                }
                default: {
                    values = Collections.unmodifiableList(new ArrayList<V>(this.values));
                }
            }
            return new KeyValuesPair(this.key, values);
        }

        public String toString() {
            return "KeyValuesPair.KeyValuesPairBuilder(key=" + this.key + ", values=" + this.values + ")";
        }
    }
}

