/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.collections.pairs;

import java.io.Serializable;
import lombok.NonNull;

public class ImmutableBox<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    @NonNull
    private final T value;

    public static <T> ImmutableBoxBuilder<T> builder() {
        return new ImmutableBoxBuilder();
    }

    public ImmutableBoxBuilder<T> toBuilder() {
        return new ImmutableBoxBuilder<T>().value(this.value);
    }

    @NonNull
    public T getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ImmutableBox)) {
            return false;
        }
        ImmutableBox other = (ImmutableBox)o;
        if (!other.canEqual(this)) {
            return false;
        }
        T this$value = this.getValue();
        T other$value = other.getValue();
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ImmutableBox;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        T $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }

    public String toString() {
        return "ImmutableBox(value=" + this.getValue() + ")";
    }

    public ImmutableBox(@NonNull T value) {
        if (value == null) {
            throw new NullPointerException("value is marked @NonNull but is null");
        }
        this.value = value;
    }

    public static class ImmutableBoxBuilder<T> {
        private T value;

        ImmutableBoxBuilder() {
        }

        public ImmutableBoxBuilder<T> value(T value) {
            this.value = value;
            return this;
        }

        public ImmutableBox<T> build() {
            return new ImmutableBox<T>(this.value);
        }

        public String toString() {
            return "ImmutableBox.ImmutableBoxBuilder(value=" + this.value + ")";
        }
    }
}

