/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.collections.modifications;

import java.util.Collection;

public enum ModifiedState {
    CLEARED,
    FIRST_MATCH,
    NEW_MATCH,
    REMOVED,
    UNMODIFIED;


    public static <T> ModifiedState isModified(Collection<T> previous, Collection<T> next) {
        boolean initialEntry;
        boolean removed;
        boolean cleared;
        boolean collectionsEqual;
        if (previous == null) {
            throw new IllegalArgumentException("First argument must not be null.");
        }
        if (next == null) {
            throw new IllegalArgumentException("Second argument must not be null.");
        }
        boolean bl = collectionsEqual = previous.containsAll(next) && next.containsAll(previous);
        if (collectionsEqual) {
            return UNMODIFIED;
        }
        boolean bl2 = cleared = next.isEmpty() && !previous.isEmpty();
        if (cleared) {
            return CLEARED;
        }
        boolean bl3 = removed = next.size() < previous.size();
        if (removed) {
            return REMOVED;
        }
        boolean bl4 = initialEntry = previous.isEmpty() && !next.isEmpty();
        if (initialEntry) {
            return FIRST_MATCH;
        }
        return NEW_MATCH;
    }
}

